/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.elytron;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=elytron/aggregate-security-event-listener=*")
@ResourceType(value="aggregate-security-event-listener")
public class AggregateSecurityEventListener<T extends AggregateSecurityEventListener<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The referenced security event listener resources to aggregate.")
    private List<String> securityEventListeners;

    public AggregateSecurityEventListener(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="security-event-listeners")
    public List<String> securityEventListeners() {
        return this.securityEventListeners;
    }

    public T securityEventListeners(List<String> value) {
        List<String> oldValue = this.securityEventListeners;
        this.securityEventListeners = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityEventListeners", oldValue, value);
        }
        return (T)this;
    }

    public T securityEventListener(String value) {
        if (this.securityEventListeners == null) {
            this.securityEventListeners = new ArrayList<String>();
        }
        this.securityEventListeners.add(value);
        return (T)this;
    }

    public T securityEventListeners(String ... args) {
        this.securityEventListeners(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }
}

