/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.ejb3;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=ejb3/application-security-domain=*")
@ResourceType(value="application-security-domain")
public class ApplicationSecurityDomain<T extends ApplicationSecurityDomain<T>>
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="Enable authorization using JACC")
    private Boolean enableJacc;
    @AttributeDocumentation(value="The deployments currently referencing this mapping")
    private List<String> referencingDeployments;
    @AttributeDocumentation(value="The Elytron security domain to be used by deployments that reference the mapped security domain")
    private String securityDomain;

    public ApplicationSecurityDomain(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="enable-jacc")
    public Boolean enableJacc() {
        return this.enableJacc;
    }

    public T enableJacc(Boolean value) {
        Boolean oldValue = this.enableJacc;
        this.enableJacc = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enableJacc", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="referencing-deployments")
    public List<String> referencingDeployments() {
        return this.referencingDeployments;
    }

    public T referencingDeployments(List<String> value) {
        List<String> oldValue = this.referencingDeployments;
        this.referencingDeployments = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("referencingDeployments", oldValue, value);
        }
        return (T)this;
    }

    public T referencingDeployment(String value) {
        if (this.referencingDeployments == null) {
            this.referencingDeployments = new ArrayList<String>();
        }
        this.referencingDeployments.add(value);
        return (T)this;
    }

    public T referencingDeployments(String ... args) {
        this.referencingDeployments(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-domain")
    public String securityDomain() {
        return this.securityDomain;
    }

    public T securityDomain(String value) {
        String oldValue = this.securityDomain;
        this.securityDomain = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityDomain", oldValue, value);
        }
        return (T)this;
    }
}

