package org.wildfly.swarm.config.undertow.configuration.mod_cluster;

import org.wildfly.swarm.config.undertow.configuration.mod_cluster.Balancer;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BalancerConsumer<T extends Balancer<T>> {

	/**
	 * Configure a pre-constructed instance of Balancer resource
	 * 
	 * @parameter Instance of Balancer to configure
	 * @return nothing
	 */
	void accept(T value);

	default BalancerConsumer<T> andThen(BalancerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}