package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerConsumer;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.BalancerSupplier;
import org.wildfly.swarm.config.undertow.configuration.mod_cluster.Balancer;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;

/**
 * A mod-cluster front end load balancer
 */
@Address("/subsystem=undertow/configuration=filter/mod-cluster=*")
@ResourceType("mod-cluster")
public class ModCluster<T extends ModCluster<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private ModClusterResources subresources = new ModClusterResources();
	@AttributeDocumentation("The frequency (in milliseconds) that mod-cluster advertises itself on the network")
	private Integer advertiseFrequency;
	@AttributeDocumentation("The path that mod-cluster is registered under.")
	private String advertisePath;
	@AttributeDocumentation("The protocol that is in use.")
	private String advertiseProtocol;
	@AttributeDocumentation("The multicast group and port that is used to advertise.")
	private String advertiseSocketBinding;
	@AttributeDocumentation("The amount of time that must elapse before a broken node is removed from the table")
	private Integer brokenNodeTimeout;
	@AttributeDocumentation("The number of connections that will be kept alive indefinitely")
	private Integer cachedConnectionsPerThread;
	@AttributeDocumentation("The amount of time a connection can be idle before it will be closed. Connections will not time out once the pool size is down to the configured minimum (as configured by cached-connections-per-thread)")
	private Integer connectionIdleTimeout;
	@AttributeDocumentation("The number of connections that will be maintained to backend servers, per IO thread.")
	private Integer connectionsPerThread;
	@AttributeDocumentation("If the load balancer should attempt to upgrade back end connections to HTTP2. If HTTP2 is not supported HTTP or HTTPS will be used as normal")
	private Boolean enableHttp2;
	@AttributeDocumentation("Determines how a failover node is chosen, in the event that the node to which a session has affinity is not available.")
	private FailoverStrategy failoverStrategy;
	@AttributeDocumentation("The frequency of health check pings to backend nodes")
	private Integer healthCheckInterval;
	@AttributeDocumentation("If push should be enabled for HTTP/2 connections")
	private Boolean http2EnablePush;
	@AttributeDocumentation("The size of the header table used for HPACK compression, in bytes. This amount of memory will be allocated per connection for compression. Larger values use more memory but may give better compression.")
	private Integer http2HeaderTableSize;
	@AttributeDocumentation("The flow control window size that controls how quickly the client can send data to the server")
	private Integer http2InitialWindowSize;
	@AttributeDocumentation("The maximum number of HTTP/2 streams that can be active at any time on a single connection")
	private Integer http2MaxConcurrentStreams;
	@AttributeDocumentation("The max HTTP/2 frame size")
	private Integer http2MaxFrameSize;
	@AttributeDocumentation("The maximum size of request headers the server is prepared to accept")
	private Integer http2MaxHeaderListSize;
	@AttributeDocumentation("A predicate that is applied to incoming requests to determine if they can perform mod cluster management commands. Provides additional security on top of what is provided by limiting management to requests that originate from the management-socket-binding")
	private String managementAccessPredicate;
	@AttributeDocumentation("The socket binding of the mod_cluster management address and port. When using mod_cluster two HTTP listeners should be defined, a public one to handle requests, and one bound to the internal network to handle mod cluster commands. This socket binding should correspond to the internal listener, and should not be publicly accessible.")
	private String managementSocketBinding;
	@AttributeDocumentation("The maximum size for AJP packets. Increasing this will allow AJP to work for requests/responses that have a large amount of headers. This is an advanced option, and must be the same between load balancers and backend servers.")
	private Integer maxAjpPacketSize;
	@AttributeDocumentation("The max amount of time that a request to a backend node can take before it is killed")
	private Integer maxRequestTime;
	@AttributeDocumentation("The number of times to attempt to retry a request if it fails. Note that if a request is not considered idempotent then it will only be retried if the proxy can be sure it was not sent to the backend server).")
	private Integer maxRetries;
	@AttributeDocumentation("The number of requests that can be queued if the connection pool is full before requests are rejected with a 503")
	private Integer requestQueueSize;
	@AttributeDocumentation("The security key that is used for the mod-cluster group. All members must use the same security key.")
	private String securityKey;
	@AttributeDocumentation("The security realm that provides the SSL configuration")
	private String securityRealm;
	@AttributeDocumentation("Reference to the SSLContext to be used by this filter.")
	private String sslContext;
	@AttributeDocumentation("If an alias check is performed")
	private Boolean useAlias;
	@AttributeDocumentation("The XNIO worker that is used to send the advertise notifications")
	private String worker;

	public ModCluster(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ModClusterResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Balancer objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Balancer objects.
	 */
	@SuppressWarnings("unchecked")
	public T balancers(java.util.List<Balancer> value) {
		this.subresources.balancers = value;
		return (T) this;
	}

	/**
	 * Add the Balancer object to the list of subresources
	 * 
	 * @param value
	 *            The Balancer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T balancer(Balancer value) {
		this.subresources.balancers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Balancer object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Balancer resource
	 * @param config
	 *            The BalancerConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T balancer(java.lang.String childKey, BalancerConsumer consumer) {
		Balancer<? extends Balancer> child = new Balancer<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		balancer(child);
		return (T) this;
	}

	/**
	 * Create and configure a Balancer object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Balancer resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T balancer(java.lang.String childKey) {
		balancer(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Balancer object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T balancer(BalancerSupplier supplier) {
		balancer(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for ModCluster
	 */
	public static class ModClusterResources {
		/**
		 * Runtime representation of a mod_cluster balancer
		 */
		@ResourceDocumentation("Runtime representation of a mod_cluster balancer")
		@SubresourceInfo("balancer")
		private List<Balancer> balancers = new java.util.ArrayList<>();

		/**
		 * Get the list of Balancer resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Balancer> balancers() {
			return this.balancers;
		}

		public Balancer balancer(java.lang.String key) {
			return this.balancers.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
	}

	public static enum FailoverStrategy {
		LOAD_BALANCED("LOAD_BALANCED"), DETERMINISTIC("DETERMINISTIC");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		FailoverStrategy(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The frequency (in milliseconds) that mod-cluster advertises itself on the
	 * network
	 */
	@ModelNodeBinding(detypedName = "advertise-frequency")
	public Integer advertiseFrequency() {
		return this.advertiseFrequency;
	}

	/**
	 * The frequency (in milliseconds) that mod-cluster advertises itself on the
	 * network
	 */
	@SuppressWarnings("unchecked")
	public T advertiseFrequency(java.lang.Integer value) {
		Object oldValue = this.advertiseFrequency;
		this.advertiseFrequency = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advertiseFrequency", oldValue, value);
		return (T) this;
	}

	/**
	 * The path that mod-cluster is registered under.
	 */
	@ModelNodeBinding(detypedName = "advertise-path")
	public String advertisePath() {
		return this.advertisePath;
	}

	/**
	 * The path that mod-cluster is registered under.
	 */
	@SuppressWarnings("unchecked")
	public T advertisePath(java.lang.String value) {
		Object oldValue = this.advertisePath;
		this.advertisePath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advertisePath", oldValue, value);
		return (T) this;
	}

	/**
	 * The protocol that is in use.
	 */
	@ModelNodeBinding(detypedName = "advertise-protocol")
	public String advertiseProtocol() {
		return this.advertiseProtocol;
	}

	/**
	 * The protocol that is in use.
	 */
	@SuppressWarnings("unchecked")
	public T advertiseProtocol(java.lang.String value) {
		Object oldValue = this.advertiseProtocol;
		this.advertiseProtocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advertiseProtocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The multicast group and port that is used to advertise.
	 */
	@ModelNodeBinding(detypedName = "advertise-socket-binding")
	public String advertiseSocketBinding() {
		return this.advertiseSocketBinding;
	}

	/**
	 * The multicast group and port that is used to advertise.
	 */
	@SuppressWarnings("unchecked")
	public T advertiseSocketBinding(java.lang.String value) {
		Object oldValue = this.advertiseSocketBinding;
		this.advertiseSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("advertiseSocketBinding", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The amount of time that must elapse before a broken node is removed from
	 * the table
	 */
	@ModelNodeBinding(detypedName = "broken-node-timeout")
	public Integer brokenNodeTimeout() {
		return this.brokenNodeTimeout;
	}

	/**
	 * The amount of time that must elapse before a broken node is removed from
	 * the table
	 */
	@SuppressWarnings("unchecked")
	public T brokenNodeTimeout(java.lang.Integer value) {
		Object oldValue = this.brokenNodeTimeout;
		this.brokenNodeTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("brokenNodeTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of connections that will be kept alive indefinitely
	 */
	@ModelNodeBinding(detypedName = "cached-connections-per-thread")
	public Integer cachedConnectionsPerThread() {
		return this.cachedConnectionsPerThread;
	}

	/**
	 * The number of connections that will be kept alive indefinitely
	 */
	@SuppressWarnings("unchecked")
	public T cachedConnectionsPerThread(java.lang.Integer value) {
		Object oldValue = this.cachedConnectionsPerThread;
		this.cachedConnectionsPerThread = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cachedConnectionsPerThread", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The amount of time a connection can be idle before it will be closed.
	 * Connections will not time out once the pool size is down to the
	 * configured minimum (as configured by cached-connections-per-thread)
	 */
	@ModelNodeBinding(detypedName = "connection-idle-timeout")
	public Integer connectionIdleTimeout() {
		return this.connectionIdleTimeout;
	}

	/**
	 * The amount of time a connection can be idle before it will be closed.
	 * Connections will not time out once the pool size is down to the
	 * configured minimum (as configured by cached-connections-per-thread)
	 */
	@SuppressWarnings("unchecked")
	public T connectionIdleTimeout(java.lang.Integer value) {
		Object oldValue = this.connectionIdleTimeout;
		this.connectionIdleTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionIdleTimeout", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of connections that will be maintained to backend servers, per
	 * IO thread.
	 */
	@ModelNodeBinding(detypedName = "connections-per-thread")
	public Integer connectionsPerThread() {
		return this.connectionsPerThread;
	}

	/**
	 * The number of connections that will be maintained to backend servers, per
	 * IO thread.
	 */
	@SuppressWarnings("unchecked")
	public T connectionsPerThread(java.lang.Integer value) {
		Object oldValue = this.connectionsPerThread;
		this.connectionsPerThread = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionsPerThread", oldValue, value);
		return (T) this;
	}

	/**
	 * If the load balancer should attempt to upgrade back end connections to
	 * HTTP2. If HTTP2 is not supported HTTP or HTTPS will be used as normal
	 */
	@ModelNodeBinding(detypedName = "enable-http2")
	public Boolean enableHttp2() {
		return this.enableHttp2;
	}

	/**
	 * If the load balancer should attempt to upgrade back end connections to
	 * HTTP2. If HTTP2 is not supported HTTP or HTTPS will be used as normal
	 */
	@SuppressWarnings("unchecked")
	public T enableHttp2(java.lang.Boolean value) {
		Object oldValue = this.enableHttp2;
		this.enableHttp2 = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableHttp2", oldValue, value);
		return (T) this;
	}

	/**
	 * Determines how a failover node is chosen, in the event that the node to
	 * which a session has affinity is not available.
	 */
	@ModelNodeBinding(detypedName = "failover-strategy")
	public FailoverStrategy failoverStrategy() {
		return this.failoverStrategy;
	}

	/**
	 * Determines how a failover node is chosen, in the event that the node to
	 * which a session has affinity is not available.
	 */
	@SuppressWarnings("unchecked")
	public T failoverStrategy(FailoverStrategy value) {
		Object oldValue = this.failoverStrategy;
		this.failoverStrategy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("failoverStrategy", oldValue, value);
		return (T) this;
	}

	/**
	 * The frequency of health check pings to backend nodes
	 */
	@ModelNodeBinding(detypedName = "health-check-interval")
	public Integer healthCheckInterval() {
		return this.healthCheckInterval;
	}

	/**
	 * The frequency of health check pings to backend nodes
	 */
	@SuppressWarnings("unchecked")
	public T healthCheckInterval(java.lang.Integer value) {
		Object oldValue = this.healthCheckInterval;
		this.healthCheckInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("healthCheckInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * If push should be enabled for HTTP/2 connections
	 */
	@ModelNodeBinding(detypedName = "http2-enable-push")
	public Boolean http2EnablePush() {
		return this.http2EnablePush;
	}

	/**
	 * If push should be enabled for HTTP/2 connections
	 */
	@SuppressWarnings("unchecked")
	public T http2EnablePush(java.lang.Boolean value) {
		Object oldValue = this.http2EnablePush;
		this.http2EnablePush = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("http2EnablePush", oldValue, value);
		return (T) this;
	}

	/**
	 * The size of the header table used for HPACK compression, in bytes. This
	 * amount of memory will be allocated per connection for compression. Larger
	 * values use more memory but may give better compression.
	 */
	@ModelNodeBinding(detypedName = "http2-header-table-size")
	public Integer http2HeaderTableSize() {
		return this.http2HeaderTableSize;
	}

	/**
	 * The size of the header table used for HPACK compression, in bytes. This
	 * amount of memory will be allocated per connection for compression. Larger
	 * values use more memory but may give better compression.
	 */
	@SuppressWarnings("unchecked")
	public T http2HeaderTableSize(java.lang.Integer value) {
		Object oldValue = this.http2HeaderTableSize;
		this.http2HeaderTableSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("http2HeaderTableSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The flow control window size that controls how quickly the client can
	 * send data to the server
	 */
	@ModelNodeBinding(detypedName = "http2-initial-window-size")
	public Integer http2InitialWindowSize() {
		return this.http2InitialWindowSize;
	}

	/**
	 * The flow control window size that controls how quickly the client can
	 * send data to the server
	 */
	@SuppressWarnings("unchecked")
	public T http2InitialWindowSize(java.lang.Integer value) {
		Object oldValue = this.http2InitialWindowSize;
		this.http2InitialWindowSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("http2InitialWindowSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of HTTP/2 streams that can be active at any time on a
	 * single connection
	 */
	@ModelNodeBinding(detypedName = "http2-max-concurrent-streams")
	public Integer http2MaxConcurrentStreams() {
		return this.http2MaxConcurrentStreams;
	}

	/**
	 * The maximum number of HTTP/2 streams that can be active at any time on a
	 * single connection
	 */
	@SuppressWarnings("unchecked")
	public T http2MaxConcurrentStreams(java.lang.Integer value) {
		Object oldValue = this.http2MaxConcurrentStreams;
		this.http2MaxConcurrentStreams = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("http2MaxConcurrentStreams", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The max HTTP/2 frame size
	 */
	@ModelNodeBinding(detypedName = "http2-max-frame-size")
	public Integer http2MaxFrameSize() {
		return this.http2MaxFrameSize;
	}

	/**
	 * The max HTTP/2 frame size
	 */
	@SuppressWarnings("unchecked")
	public T http2MaxFrameSize(java.lang.Integer value) {
		Object oldValue = this.http2MaxFrameSize;
		this.http2MaxFrameSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("http2MaxFrameSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The maximum size of request headers the server is prepared to accept
	 */
	@ModelNodeBinding(detypedName = "http2-max-header-list-size")
	public Integer http2MaxHeaderListSize() {
		return this.http2MaxHeaderListSize;
	}

	/**
	 * The maximum size of request headers the server is prepared to accept
	 */
	@SuppressWarnings("unchecked")
	public T http2MaxHeaderListSize(java.lang.Integer value) {
		Object oldValue = this.http2MaxHeaderListSize;
		this.http2MaxHeaderListSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("http2MaxHeaderListSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * A predicate that is applied to incoming requests to determine if they can
	 * perform mod cluster management commands. Provides additional security on
	 * top of what is provided by limiting management to requests that originate
	 * from the management-socket-binding
	 */
	@ModelNodeBinding(detypedName = "management-access-predicate")
	public String managementAccessPredicate() {
		return this.managementAccessPredicate;
	}

	/**
	 * A predicate that is applied to incoming requests to determine if they can
	 * perform mod cluster management commands. Provides additional security on
	 * top of what is provided by limiting management to requests that originate
	 * from the management-socket-binding
	 */
	@SuppressWarnings("unchecked")
	public T managementAccessPredicate(java.lang.String value) {
		Object oldValue = this.managementAccessPredicate;
		this.managementAccessPredicate = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managementAccessPredicate", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The socket binding of the mod_cluster management address and port. When
	 * using mod_cluster two HTTP listeners should be defined, a public one to
	 * handle requests, and one bound to the internal network to handle mod
	 * cluster commands. This socket binding should correspond to the internal
	 * listener, and should not be publicly accessible.
	 */
	@ModelNodeBinding(detypedName = "management-socket-binding")
	public String managementSocketBinding() {
		return this.managementSocketBinding;
	}

	/**
	 * The socket binding of the mod_cluster management address and port. When
	 * using mod_cluster two HTTP listeners should be defined, a public one to
	 * handle requests, and one bound to the internal network to handle mod
	 * cluster commands. This socket binding should correspond to the internal
	 * listener, and should not be publicly accessible.
	 */
	@SuppressWarnings("unchecked")
	public T managementSocketBinding(java.lang.String value) {
		Object oldValue = this.managementSocketBinding;
		this.managementSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("managementSocketBinding", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum size for AJP packets. Increasing this will allow AJP to work
	 * for requests/responses that have a large amount of headers. This is an
	 * advanced option, and must be the same between load balancers and backend
	 * servers.
	 */
	@ModelNodeBinding(detypedName = "max-ajp-packet-size")
	public Integer maxAjpPacketSize() {
		return this.maxAjpPacketSize;
	}

	/**
	 * The maximum size for AJP packets. Increasing this will allow AJP to work
	 * for requests/responses that have a large amount of headers. This is an
	 * advanced option, and must be the same between load balancers and backend
	 * servers.
	 */
	@SuppressWarnings("unchecked")
	public T maxAjpPacketSize(java.lang.Integer value) {
		Object oldValue = this.maxAjpPacketSize;
		this.maxAjpPacketSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxAjpPacketSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The max amount of time that a request to a backend node can take before
	 * it is killed
	 */
	@ModelNodeBinding(detypedName = "max-request-time")
	public Integer maxRequestTime() {
		return this.maxRequestTime;
	}

	/**
	 * The max amount of time that a request to a backend node can take before
	 * it is killed
	 */
	@SuppressWarnings("unchecked")
	public T maxRequestTime(java.lang.Integer value) {
		Object oldValue = this.maxRequestTime;
		this.maxRequestTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRequestTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of times to attempt to retry a request if it fails. Note that
	 * if a request is not considered idempotent then it will only be retried if
	 * the proxy can be sure it was not sent to the backend server).
	 */
	@ModelNodeBinding(detypedName = "max-retries")
	public Integer maxRetries() {
		return this.maxRetries;
	}

	/**
	 * The number of times to attempt to retry a request if it fails. Note that
	 * if a request is not considered idempotent then it will only be retried if
	 * the proxy can be sure it was not sent to the backend server).
	 */
	@SuppressWarnings("unchecked")
	public T maxRetries(java.lang.Integer value) {
		Object oldValue = this.maxRetries;
		this.maxRetries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxRetries", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of requests that can be queued if the connection pool is full
	 * before requests are rejected with a 503
	 */
	@ModelNodeBinding(detypedName = "request-queue-size")
	public Integer requestQueueSize() {
		return this.requestQueueSize;
	}

	/**
	 * The number of requests that can be queued if the connection pool is full
	 * before requests are rejected with a 503
	 */
	@SuppressWarnings("unchecked")
	public T requestQueueSize(java.lang.Integer value) {
		Object oldValue = this.requestQueueSize;
		this.requestQueueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("requestQueueSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The security key that is used for the mod-cluster group. All members must
	 * use the same security key.
	 */
	@ModelNodeBinding(detypedName = "security-key")
	public String securityKey() {
		return this.securityKey;
	}

	/**
	 * The security key that is used for the mod-cluster group. All members must
	 * use the same security key.
	 */
	@SuppressWarnings("unchecked")
	public T securityKey(java.lang.String value) {
		Object oldValue = this.securityKey;
		this.securityKey = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityKey", oldValue, value);
		return (T) this;
	}

	/**
	 * The security realm that provides the SSL configuration
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * The security realm that provides the SSL configuration
	 */
	@SuppressWarnings("unchecked")
	public T securityRealm(java.lang.String value) {
		Object oldValue = this.securityRealm;
		this.securityRealm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityRealm", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to the SSLContext to be used by this filter.
	 */
	@ModelNodeBinding(detypedName = "ssl-context")
	public String sslContext() {
		return this.sslContext;
	}

	/**
	 * Reference to the SSLContext to be used by this filter.
	 */
	@SuppressWarnings("unchecked")
	public T sslContext(java.lang.String value) {
		Object oldValue = this.sslContext;
		this.sslContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sslContext", oldValue, value);
		return (T) this;
	}

	/**
	 * If an alias check is performed
	 */
	@ModelNodeBinding(detypedName = "use-alias")
	public Boolean useAlias() {
		return this.useAlias;
	}

	/**
	 * If an alias check is performed
	 */
	@SuppressWarnings("unchecked")
	public T useAlias(java.lang.Boolean value) {
		Object oldValue = this.useAlias;
		this.useAlias = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useAlias", oldValue, value);
		return (T) this;
	}

	/**
	 * The XNIO worker that is used to send the advertise notifications
	 */
	@ModelNodeBinding(detypedName = "worker")
	public String worker() {
		return this.worker;
	}

	/**
	 * The XNIO worker that is used to send the advertise notifications
	 */
	@SuppressWarnings("unchecked")
	public T worker(java.lang.String value) {
		Object oldValue = this.worker;
		this.worker = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("worker", oldValue, value);
		return (T) this;
	}
}