package org.wildfly.swarm.config.transactions;

import org.wildfly.swarm.config.transactions.CommitMarkableResource;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface CommitMarkableResourceConsumer<T extends CommitMarkableResource<T>> {

	/**
	 * Configure a pre-constructed instance of CommitMarkableResource resource
	 * 
	 * @parameter Instance of CommitMarkableResource to configure
	 * @return nothing
	 */
	void accept(T value);

	default CommitMarkableResourceConsumer<T> andThen(
			CommitMarkableResourceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}