package org.wildfly.swarm.config.singleton;

import org.wildfly.swarm.config.singleton.SingletonPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SingletonPolicyConsumer<T extends SingletonPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of SingletonPolicy resource
	 * 
	 * @parameter Instance of SingletonPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default SingletonPolicyConsumer<T> andThen(SingletonPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}