package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.security.security_domain.ClassicAuthorization;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ClassicAuthorizationConsumer<T extends ClassicAuthorization<T>> {

	/**
	 * Configure a pre-constructed instance of ClassicAuthorization resource
	 * 
	 * @parameter Instance of ClassicAuthorization to configure
	 * @return nothing
	 */
	void accept(T value);

	default ClassicAuthorizationConsumer<T> andThen(
			ClassicAuthorizationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}