package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.security.ElytronTrustStore;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ElytronTrustStoreConsumer<T extends ElytronTrustStore<T>> {

	/**
	 * Configure a pre-constructed instance of ElytronTrustStore resource
	 * 
	 * @parameter Instance of ElytronTrustStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default ElytronTrustStoreConsumer<T> andThen(
			ElytronTrustStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}