package org.wildfly.swarm.config.security;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of an Elytron-compatible realm that delegates
 * authentication decisions to a legacy security domain.
 */
@Address("/subsystem=security/elytron-realm=*")
@ResourceType("elytron-realm")
public class ElytronRealm<T extends ElytronRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Indicates to the realm if it should apply the role mappers defined in the legacy domain to the roles obtained from authenticated Subjects or not.")
	private Boolean applyRoleMappers;
	@AttributeDocumentation("The name of the legacy security domain to which authentication will be delegated.")
	private String legacyJaasConfig;

	public ElytronRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Indicates to the realm if it should apply the role mappers defined in the
	 * legacy domain to the roles obtained from authenticated Subjects or not.
	 */
	@ModelNodeBinding(detypedName = "apply-role-mappers")
	public Boolean applyRoleMappers() {
		return this.applyRoleMappers;
	}

	/**
	 * Indicates to the realm if it should apply the role mappers defined in the
	 * legacy domain to the roles obtained from authenticated Subjects or not.
	 */
	@SuppressWarnings("unchecked")
	public T applyRoleMappers(java.lang.Boolean value) {
		Object oldValue = this.applyRoleMappers;
		this.applyRoleMappers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("applyRoleMappers", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the legacy security domain to which authentication will be
	 * delegated.
	 */
	@ModelNodeBinding(detypedName = "legacy-jaas-config")
	public String legacyJaasConfig() {
		return this.legacyJaasConfig;
	}

	/**
	 * The name of the legacy security domain to which authentication will be
	 * delegated.
	 */
	@SuppressWarnings("unchecked")
	public T legacyJaasConfig(java.lang.String value) {
		Object oldValue = this.legacyJaasConfig;
		this.legacyJaasConfig = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("legacyJaasConfig", oldValue, value);
		return (T) this;
	}
}