package org.wildfly.swarm.config.resource.adapters;

import org.wildfly.swarm.config.resource.adapters.ResourceAdapter;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ResourceAdapterConsumer<T extends ResourceAdapter<T>> {

	/**
	 * Configure a pre-constructed instance of ResourceAdapter resource
	 * 
	 * @parameter Instance of ResourceAdapter to configure
	 * @return nothing
	 */
	void accept(T value);

	default ResourceAdapterConsumer<T> andThen(ResourceAdapterConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}