package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.remoting.RemoteOutboundConnection;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface RemoteOutboundConnectionConsumer<T extends RemoteOutboundConnection<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteOutboundConnection resource
	 * 
	 * @parameter Instance of RemoteOutboundConnection to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteOutboundConnectionConsumer<T> andThen(
			RemoteOutboundConnectionConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}