package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.ReplicationSlaveHAPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ReplicationSlaveHAPolicyConsumer<T extends ReplicationSlaveHAPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of ReplicationSlaveHAPolicy resource
	 * 
	 * @parameter Instance of ReplicationSlaveHAPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default ReplicationSlaveHAPolicyConsumer<T> andThen(
			ReplicationSlaveHAPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}