package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.ReplicationColocatedHAPolicy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ReplicationColocatedHAPolicyConsumer<T extends ReplicationColocatedHAPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of ReplicationColocatedHAPolicy
	 * resource
	 * 
	 * @parameter Instance of ReplicationColocatedHAPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default ReplicationColocatedHAPolicyConsumer<T> andThen(
			ReplicationColocatedHAPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}