package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.Queue;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface QueueConsumer<T extends Queue<T>> {

	/**
	 * Configure a pre-constructed instance of Queue resource
	 * 
	 * @parameter Instance of Queue to configure
	 * @return nothing
	 */
	void accept(T value);

	default QueueConsumer<T> andThen(QueueConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}