package org.wildfly.swarm.config.management.security_realm.authorization;

import org.wildfly.swarm.config.management.security_realm.authorization.UsernameFilterUsernameToDn;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface UsernameFilterUsernameToDnConsumer<T extends UsernameFilterUsernameToDn<T>> {

	/**
	 * Configure a pre-constructed instance of UsernameFilterUsernameToDn
	 * resource
	 * 
	 * @parameter Instance of UsernameFilterUsernameToDn to configure
	 * @return nothing
	 */
	void accept(T value);

	default UsernameFilterUsernameToDnConsumer<T> andThen(
			UsernameFilterUsernameToDnConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}