package org.wildfly.swarm.config.management.security_realm.authentication;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * An authorized user.
 */
@Address("/core-service=management/security-realm=*/authentication=users/user=*")
@ResourceType("user")
public class User<T extends User<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The reference to credential for the password stored in CredentialStore under defined alias or clear text password.")
	private Map credentialReference;
	@AttributeDocumentation("The user's password.")
	private String password;

	public User(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The reference to credential for the password stored in CredentialStore
	 * under defined alias or clear text password.
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * The reference to credential for the password stored in CredentialStore
	 * under defined alias or clear text password.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * The reference to credential for the password stored in CredentialStore
	 * under defined alias or clear text password.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The user's password.
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * The user's password.
	 */
	@SuppressWarnings("unchecked")
	public T password(java.lang.String value) {
		Object oldValue = this.password;
		this.password = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("password", oldValue, value);
		return (T) this;
	}
}