package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.HTTPInterfaceManagementInterface;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface HTTPInterfaceManagementInterfaceConsumer<T extends HTTPInterfaceManagementInterface<T>> {

	/**
	 * Configure a pre-constructed instance of HTTPInterfaceManagementInterface
	 * resource
	 * 
	 * @parameter Instance of HTTPInterfaceManagementInterface to configure
	 * @return nothing
	 */
	void accept(T value);

	default HTTPInterfaceManagementInterfaceConsumer<T> andThen(
			HTTPInterfaceManagementInterfaceConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}