package org.wildfly.swarm.config.logging;

import org.wildfly.swarm.config.logging.Logger;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface LoggerConsumer<T extends Logger<T>> {

	/**
	 * Configure a pre-constructed instance of Logger resource
	 * 
	 * @parameter Instance of Logger to configure
	 * @return nothing
	 */
	void accept(T value);

	default LoggerConsumer<T> andThen(LoggerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}