package org.wildfly.swarm.config.jgroups.stack.transport;

import org.wildfly.swarm.config.jgroups.stack.transport.TimerThreadPool;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface TimerThreadPoolConsumer<T extends TimerThreadPool<T>> {

	/**
	 * Configure a pre-constructed instance of TimerThreadPool resource
	 * 
	 * @parameter Instance of TimerThreadPool to configure
	 * @return nothing
	 */
	void accept(T value);

	default TimerThreadPoolConsumer<T> andThen(TimerThreadPoolConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}