package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A cache store property with name and value.
 */
@Addresses({
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=custom/property=*",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=file/property=*",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=binary-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=mixed-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/invalidation-cache=*/store=remote/property=*",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=custom/property=*",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=file/property=*",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=binary-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=mixed-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/local-cache=*/store=remote/property=*",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=custom/property=*",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=binary-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=file/property=*",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=mixed-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/replicated-cache=*/store=remote/property=*",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=custom/property=*",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=binary-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=file/property=*",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=mixed-jdbc/property=*",
		"/subsystem=infinispan/cache-container=*/distributed-cache=*/store=remote/property=*"})
@ResourceType("property")
public class Property<T extends Property<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The value of the cache store property.")
	private String value;

	public Property(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The value of the cache store property.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value of the cache store property.
	 */
	@SuppressWarnings("unchecked")
	public T value(java.lang.String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}