package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.DistributedCache;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface DistributedCacheConsumer<T extends DistributedCache<T>> {

	/**
	 * Configure a pre-constructed instance of DistributedCache resource
	 * 
	 * @parameter Instance of DistributedCache to configure
	 * @return nothing
	 */
	void accept(T value);

	default DistributedCacheConsumer<T> andThen(
			DistributedCacheConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}