package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.EvictionComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.ExpirationComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.ExpirationComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.CustomStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.CustomStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.NoneStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.NoneStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.BackupForComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BackupForComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.TransactionComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.BinaryJDBCStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BinaryJDBCStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.FileStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.FileStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.StateTransferComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.StateTransferComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.JDBCStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.JDBCStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.PartitionHandlingComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.PartitionHandlingComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.LockingComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.BackupsComponentConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.BackupsComponentSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.MixedJDBCStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.MixedJDBCStoreSupplier;
import org.wildfly.swarm.config.infinispan.cache_container.RemoteStoreConsumer;
import org.wildfly.swarm.config.infinispan.cache_container.RemoteStoreSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Arrays;
import java.util.Map;
import org.wildfly.swarm.config.infinispan.Mode;

/**
 * A distributed cache configuration.
 */
@Address("/subsystem=infinispan/cache-container=*/distributed-cache=*")
@ResourceType("distributed-cache")
public class DistributedCache<T extends DistributedCache<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private DistributedCacheResources subresources = new DistributedCacheResources();
	@AttributeDocumentation("The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.")
	private Long activations;
	@AttributeDocumentation("If enabled, this will cause marshalling of entries to be performed asynchronously.")
	private Boolean asyncMarshalling;
	@AttributeDocumentation("Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.")
	private Long averageReadTime;
	@AttributeDocumentation("The average time taken to replicate data around the cluster. May return null if the cache is not started.")
	private Long averageReplicationTime;
	@AttributeDocumentation("Average time (in ms) for cache writes. May return null if the cache is not started.")
	private Long averageWriteTime;
	@AttributeDocumentation("The status of the cache component. May return null if the cache is not started.")
	private String cacheStatus;
	@AttributeDocumentation("Controls the proportion of entries that will reside on the local node, compared to the other nodes in the cluster.")
	private Double capacityFactor;
	@AttributeDocumentation("Defines the consistent hash strategy for the cache.")
	private ConsistentHashStrategy consistentHashStrategy;
	@AttributeDocumentation("Time (in secs) since cache started. May return null if the cache is not started.")
	private Long elapsedTime;
	@AttributeDocumentation("The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.")
	private Double hitRatio;
	@AttributeDocumentation("The number of cache attribute hits. May return null if the cache is not started.")
	private Long hits;
	@AttributeDocumentation("If enabled, entries will be indexed when they are added to the cache. Indexes will be updated as entries change or are removed.")
	private String indexing;
	@AttributeDocumentation("Properties to control indexing behaviour")
	private Map indexingProperties;
	@AttributeDocumentation("The number of cache invalidations. May return null if the cache is not started.")
	private Long invalidations;
	@AttributeDocumentation("The jndi-name to which to bind this cache instance.")
	private String jndiName;
	@AttributeDocumentation("Maximum lifespan of an entry placed in the L1 cache. This element configures the L1 cache behavior in 'distributed' caches instances. In any other cache modes, this element is ignored.")
	private Long l1Lifespan;
	@AttributeDocumentation("The number of cache attribute misses. May return null if the cache is not started.")
	private Long misses;
	@AttributeDocumentation("Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC for synchronous operation.")
	private Mode mode;
	@AttributeDocumentation("The module whose class loader should be used when building this cache's configuration.")
	private String module;
	@AttributeDocumentation("The current number of entries in the cache. May return null if the cache is not started.")
	private Integer numberOfEntries;
	@AttributeDocumentation("Number of cluster-wide replicas for each cache entry.")
	private Integer owners;
	@AttributeDocumentation("The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.")
	private Long passivations;
	@AttributeDocumentation("In ASYNC mode, this attribute controls how often the asynchronous thread used to flush the replication queue runs. This should be a positive integer which represents thread wakeup time in milliseconds.")
	private Long queueFlushInterval;
	@AttributeDocumentation("In ASYNC mode, this attribute can be used to trigger flushing of the queue when it reaches a specific threshold.")
	private Integer queueSize;
	@AttributeDocumentation("The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.")
	private Double readWriteRatio;
	@AttributeDocumentation("In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when making a remote call, after which the call is aborted and an exception is thrown.")
	private Long remoteTimeout;
	@AttributeDocumentation("The number of cache attribute remove hits. May return null if the cache is not started.")
	private Long removeHits;
	@AttributeDocumentation("The number of cache attribute remove misses. May return null if the cache is not started.")
	private Long removeMisses;
	@AttributeDocumentation("The number of times data was replicated around the cluster. May return null if the cache is not started.")
	private Long replicationCount;
	@AttributeDocumentation("The number of data replication failures. May return null if the cache is not started.")
	private Long replicationFailures;
	@AttributeDocumentation("Controls the number of hash space segments which is the granularity for key distribution in the cluster. Value must be strictly positive.")
	private Integer segments;
	@AttributeDocumentation("If enabled, statistics will be collected for this cache")
	private Boolean statisticsEnabled;
	@AttributeDocumentation("The number of cache attribute put operations. May return null if the cache is not started.")
	private Long stores;
	@AttributeDocumentation("The data replication success ratio (successes/successes+failures). May return null if the cache is not started.")
	private Double successRatio;
	@AttributeDocumentation("Time (in secs) since cache statistics were reset. May return null if the cache is not started.")
	private Long timeSinceReset;

	public DistributedCache(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public DistributedCacheResources subresources() {
		return this.subresources;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent(
			org.wildfly.swarm.config.infinispan.cache_container.EvictionComponent value) {
		this.subresources.evictionComponent = value;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent(EvictionComponentConsumer consumer) {
		EvictionComponent<? extends EvictionComponent> child = new EvictionComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.evictionComponent = child;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent() {
		EvictionComponent<? extends EvictionComponent> child = new EvictionComponent<>();
		this.subresources.evictionComponent = child;
		return (T) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T evictionComponent(EvictionComponentSupplier supplier) {
		this.subresources.evictionComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent(
			org.wildfly.swarm.config.infinispan.cache_container.ExpirationComponent value) {
		this.subresources.expirationComponent = value;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent(ExpirationComponentConsumer consumer) {
		ExpirationComponent<? extends ExpirationComponent> child = new ExpirationComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.expirationComponent = child;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent() {
		ExpirationComponent<? extends ExpirationComponent> child = new ExpirationComponent<>();
		this.subresources.expirationComponent = child;
		return (T) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public T expirationComponent(ExpirationComponentSupplier supplier) {
		this.subresources.expirationComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore(
			org.wildfly.swarm.config.infinispan.cache_container.CustomStore value) {
		this.subresources.customStore = value;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore(CustomStoreConsumer consumer) {
		CustomStore<? extends CustomStore> child = new CustomStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.customStore = child;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore() {
		CustomStore<? extends CustomStore> child = new CustomStore<>();
		this.subresources.customStore = child;
		return (T) this;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T customStore(CustomStoreSupplier supplier) {
		this.subresources.customStore = supplier.get();
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore(
			org.wildfly.swarm.config.infinispan.cache_container.NoneStore value) {
		this.subresources.noneStore = value;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore(NoneStoreConsumer consumer) {
		NoneStore<? extends NoneStore> child = new NoneStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.noneStore = child;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore() {
		NoneStore<? extends NoneStore> child = new NoneStore<>();
		this.subresources.noneStore = child;
		return (T) this;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public T noneStore(NoneStoreSupplier supplier) {
		this.subresources.noneStore = supplier.get();
		return (T) this;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site
	 * replication).
	 */
	@SuppressWarnings("unchecked")
	public T backupForComponent(
			org.wildfly.swarm.config.infinispan.cache_container.BackupForComponent value) {
		this.subresources.backupForComponent = value;
		return (T) this;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site
	 * replication).
	 */
	@SuppressWarnings("unchecked")
	public T backupForComponent(BackupForComponentConsumer consumer) {
		BackupForComponent<? extends BackupForComponent> child = new BackupForComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.backupForComponent = child;
		return (T) this;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site
	 * replication).
	 */
	@SuppressWarnings("unchecked")
	public T backupForComponent() {
		BackupForComponent<? extends BackupForComponent> child = new BackupForComponent<>();
		this.subresources.backupForComponent = child;
		return (T) this;
	}

	/**
	 * A cache for which this cache acts as a backup (for use with cross site
	 * replication).
	 */
	@SuppressWarnings("unchecked")
	public T backupForComponent(BackupForComponentSupplier supplier) {
		this.subresources.backupForComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(
			org.wildfly.swarm.config.infinispan.cache_container.TransactionComponent value) {
		this.subresources.transactionComponent = value;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentConsumer consumer) {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent() {
		TransactionComponent<? extends TransactionComponent> child = new TransactionComponent<>();
		this.subresources.transactionComponent = child;
		return (T) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public T transactionComponent(TransactionComponentSupplier supplier) {
		this.subresources.transactionComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore(
			org.wildfly.swarm.config.infinispan.cache_container.BinaryJDBCStore value) {
		this.subresources.binaryJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore(BinaryJDBCStoreConsumer consumer) {
		BinaryJDBCStore<? extends BinaryJDBCStore> child = new BinaryJDBCStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.binaryJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore() {
		BinaryJDBCStore<? extends BinaryJDBCStore> child = new BinaryJDBCStore<>();
		this.subresources.binaryJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T binaryJdbcStore(BinaryJDBCStoreSupplier supplier) {
		this.subresources.binaryJdbcStore = supplier.get();
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore(
			org.wildfly.swarm.config.infinispan.cache_container.FileStore value) {
		this.subresources.fileStore = value;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore(FileStoreConsumer consumer) {
		FileStore<? extends FileStore> child = new FileStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.fileStore = child;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore() {
		FileStore<? extends FileStore> child = new FileStore<>();
		this.subresources.fileStore = child;
		return (T) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T fileStore(FileStoreSupplier supplier) {
		this.subresources.fileStore = supplier.get();
		return (T) this;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferComponent(
			org.wildfly.swarm.config.infinispan.cache_container.StateTransferComponent value) {
		this.subresources.stateTransferComponent = value;
		return (T) this;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferComponent(StateTransferComponentConsumer consumer) {
		StateTransferComponent<? extends StateTransferComponent> child = new StateTransferComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.stateTransferComponent = child;
		return (T) this;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferComponent() {
		StateTransferComponent<? extends StateTransferComponent> child = new StateTransferComponent<>();
		this.subresources.stateTransferComponent = child;
		return (T) this;
	}

	/**
	 * The state transfer configuration for distributed and replicated caches.
	 */
	@SuppressWarnings("unchecked")
	public T stateTransferComponent(StateTransferComponentSupplier supplier) {
		this.subresources.stateTransferComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcStore(
			org.wildfly.swarm.config.infinispan.cache_container.JDBCStore value) {
		this.subresources.jdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcStore(JDBCStoreConsumer consumer) {
		JDBCStore<? extends JDBCStore> child = new JDBCStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.jdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcStore() {
		JDBCStore<? extends JDBCStore> child = new JDBCStore<>();
		this.subresources.jdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcStore(JDBCStoreSupplier supplier) {
		this.subresources.jdbcStore = supplier.get();
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent(
			org.wildfly.swarm.config.infinispan.cache_container.PartitionHandlingComponent value) {
		this.subresources.partitionHandlingComponent = value;
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent(
			PartitionHandlingComponentConsumer consumer) {
		PartitionHandlingComponent<? extends PartitionHandlingComponent> child = new PartitionHandlingComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.partitionHandlingComponent = child;
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent() {
		PartitionHandlingComponent<? extends PartitionHandlingComponent> child = new PartitionHandlingComponent<>();
		this.subresources.partitionHandlingComponent = child;
		return (T) this;
	}

	/**
	 * The partition handling configuration for distributed and replicated
	 * caches.
	 */
	@SuppressWarnings("unchecked")
	public T partitionHandlingComponent(
			PartitionHandlingComponentSupplier supplier) {
		this.subresources.partitionHandlingComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(
			org.wildfly.swarm.config.infinispan.cache_container.LockingComponent value) {
		this.subresources.lockingComponent = value;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponentConsumer consumer) {
		LockingComponent<? extends LockingComponent> child = new LockingComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.lockingComponent = child;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent() {
		LockingComponent<? extends LockingComponent> child = new LockingComponent<>();
		this.subresources.lockingComponent = child;
		return (T) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public T lockingComponent(LockingComponentSupplier supplier) {
		this.subresources.lockingComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The remote backups for this cache.
	 */
	@SuppressWarnings("unchecked")
	public T backupsComponent(
			org.wildfly.swarm.config.infinispan.cache_container.BackupsComponent value) {
		this.subresources.backupsComponent = value;
		return (T) this;
	}

	/**
	 * The remote backups for this cache.
	 */
	@SuppressWarnings("unchecked")
	public T backupsComponent(BackupsComponentConsumer consumer) {
		BackupsComponent<? extends BackupsComponent> child = new BackupsComponent<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.backupsComponent = child;
		return (T) this;
	}

	/**
	 * The remote backups for this cache.
	 */
	@SuppressWarnings("unchecked")
	public T backupsComponent() {
		BackupsComponent<? extends BackupsComponent> child = new BackupsComponent<>();
		this.subresources.backupsComponent = child;
		return (T) this;
	}

	/**
	 * The remote backups for this cache.
	 */
	@SuppressWarnings("unchecked")
	public T backupsComponent(BackupsComponentSupplier supplier) {
		this.subresources.backupsComponent = supplier.get();
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore(
			org.wildfly.swarm.config.infinispan.cache_container.MixedJDBCStore value) {
		this.subresources.mixedJdbcStore = value;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore(MixedJDBCStoreConsumer consumer) {
		MixedJDBCStore<? extends MixedJDBCStore> child = new MixedJDBCStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.mixedJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore() {
		MixedJDBCStore<? extends MixedJDBCStore> child = new MixedJDBCStore<>();
		this.subresources.mixedJdbcStore = child;
		return (T) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T mixedJdbcStore(MixedJDBCStoreSupplier supplier) {
		this.subresources.mixedJdbcStore = supplier.get();
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore(
			org.wildfly.swarm.config.infinispan.cache_container.RemoteStore value) {
		this.subresources.remoteStore = value;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore(RemoteStoreConsumer consumer) {
		RemoteStore<? extends RemoteStore> child = new RemoteStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.remoteStore = child;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore() {
		RemoteStore<? extends RemoteStore> child = new RemoteStore<>();
		this.subresources.remoteStore = child;
		return (T) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public T remoteStore(RemoteStoreSupplier supplier) {
		this.subresources.remoteStore = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for DistributedCache
	 */
	public static class DistributedCacheResources {
		@SingletonResource
		@ResourceDocumentation("The cache eviction configuration.")
		private EvictionComponent evictionComponent;
		@SingletonResource
		@ResourceDocumentation("The cache expiration configuration.")
		private ExpirationComponent expirationComponent;
		@SingletonResource
		@ResourceDocumentation("The cache store configuration.")
		private CustomStore customStore;
		@SingletonResource
		@ResourceDocumentation("A store-less configuration.")
		private NoneStore noneStore;
		@SingletonResource
		@ResourceDocumentation("A cache for which this cache acts as a backup (for use with cross site replication).")
		private BackupForComponent backupForComponent;
		@SingletonResource
		@ResourceDocumentation("The cache transaction configuration.")
		private TransactionComponent transactionComponent;
		@SingletonResource
		@ResourceDocumentation("The cache JDBC store configuration.")
		private BinaryJDBCStore binaryJdbcStore;
		@SingletonResource
		@ResourceDocumentation("The cache file store configuration.")
		private FileStore fileStore;
		@SingletonResource
		@ResourceDocumentation("The state transfer configuration for distributed and replicated caches.")
		private StateTransferComponent stateTransferComponent;
		@SingletonResource
		@ResourceDocumentation("The cache JDBC store configuration.")
		private JDBCStore jdbcStore;
		@SingletonResource
		@ResourceDocumentation("The partition handling configuration for distributed and replicated caches.")
		private PartitionHandlingComponent partitionHandlingComponent;
		@SingletonResource
		@ResourceDocumentation("The locking configuration of the cache.")
		private LockingComponent lockingComponent;
		@SingletonResource
		@ResourceDocumentation("The remote backups for this cache.")
		private BackupsComponent backupsComponent;
		@SingletonResource
		@ResourceDocumentation("The cache JDBC store configuration.")
		private MixedJDBCStore mixedJdbcStore;
		@SingletonResource
		@ResourceDocumentation("The cache remote store configuration.")
		private RemoteStore remoteStore;

		/**
		 * The cache eviction configuration.
		 */
		@Subresource
		public EvictionComponent evictionComponent() {
			return this.evictionComponent;
		}

		/**
		 * The cache expiration configuration.
		 */
		@Subresource
		public ExpirationComponent expirationComponent() {
			return this.expirationComponent;
		}

		/**
		 * The cache store configuration.
		 */
		@Subresource
		public CustomStore customStore() {
			return this.customStore;
		}

		/**
		 * A store-less configuration.
		 */
		@Subresource
		public NoneStore noneStore() {
			return this.noneStore;
		}

		/**
		 * A cache for which this cache acts as a backup (for use with cross
		 * site replication).
		 */
		@Subresource
		public BackupForComponent backupForComponent() {
			return this.backupForComponent;
		}

		/**
		 * The cache transaction configuration.
		 */
		@Subresource
		public TransactionComponent transactionComponent() {
			return this.transactionComponent;
		}

		/**
		 * The cache JDBC store configuration.
		 */
		@Subresource
		public BinaryJDBCStore binaryJdbcStore() {
			return this.binaryJdbcStore;
		}

		/**
		 * The cache file store configuration.
		 */
		@Subresource
		public FileStore fileStore() {
			return this.fileStore;
		}

		/**
		 * The state transfer configuration for distributed and replicated
		 * caches.
		 */
		@Subresource
		public StateTransferComponent stateTransferComponent() {
			return this.stateTransferComponent;
		}

		/**
		 * The cache JDBC store configuration.
		 */
		@Subresource
		public JDBCStore jdbcStore() {
			return this.jdbcStore;
		}

		/**
		 * The partition handling configuration for distributed and replicated
		 * caches.
		 */
		@Subresource
		public PartitionHandlingComponent partitionHandlingComponent() {
			return this.partitionHandlingComponent;
		}

		/**
		 * The locking configuration of the cache.
		 */
		@Subresource
		public LockingComponent lockingComponent() {
			return this.lockingComponent;
		}

		/**
		 * The remote backups for this cache.
		 */
		@Subresource
		public BackupsComponent backupsComponent() {
			return this.backupsComponent;
		}

		/**
		 * The cache JDBC store configuration.
		 */
		@Subresource
		public MixedJDBCStore mixedJdbcStore() {
			return this.mixedJdbcStore;
		}

		/**
		 * The cache remote store configuration.
		 */
		@Subresource
		public RemoteStore remoteStore() {
			return this.remoteStore;
		}
	}

	public static enum ConsistentHashStrategy {
		INTER_CACHE("INTER_CACHE"), INTRA_CACHE("INTRA_CACHE");
		private final String allowedValue;

		/**
		 * Returns the allowed value for the management model.
		 * 
		 * @return the allowed model value
		 */
		public String getAllowedValue() {
			return allowedValue;
		}

		ConsistentHashStrategy(java.lang.String allowedValue) {
			this.allowedValue = allowedValue;
		}

		@Override
		public String toString() {
			return allowedValue;
		}
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a
	 * cache store) . May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a
	 * cache store) . May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T activations(java.lang.Long value) {
		Object oldValue = this.activations;
		this.activations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("activations", oldValue, value);
		return (T) this;
	}

	/**
	 * If enabled, this will cause marshalling of entries to be performed
	 * asynchronously.
	 */
	@ModelNodeBinding(detypedName = "async-marshalling")
	public Boolean asyncMarshalling() {
		return this.asyncMarshalling;
	}

	/**
	 * If enabled, this will cause marshalling of entries to be performed
	 * asynchronously.
	 */
	@SuppressWarnings("unchecked")
	public T asyncMarshalling(java.lang.Boolean value) {
		Object oldValue = this.asyncMarshalling;
		this.asyncMarshalling = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("asyncMarshalling", oldValue, value);
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May
	 * return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May
	 * return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageReadTime(java.lang.Long value) {
		Object oldValue = this.averageReadTime;
		this.averageReadTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageReadTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return
	 * null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-replication-time")
	public Long averageReplicationTime() {
		return this.averageReplicationTime;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return
	 * null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageReplicationTime(java.lang.Long value) {
		Object oldValue = this.averageReplicationTime;
		this.averageReplicationTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageReplicationTime", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is
	 * not started.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is
	 * not started.
	 */
	@SuppressWarnings("unchecked")
	public T averageWriteTime(java.lang.Long value) {
		Object oldValue = this.averageWriteTime;
		this.averageWriteTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageWriteTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The status of the cache component. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "cache-status")
	public String cacheStatus() {
		return this.cacheStatus;
	}

	/**
	 * The status of the cache component. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T cacheStatus(java.lang.String value) {
		Object oldValue = this.cacheStatus;
		this.cacheStatus = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cacheStatus", oldValue, value);
		return (T) this;
	}

	/**
	 * Controls the proportion of entries that will reside on the local node,
	 * compared to the other nodes in the cluster.
	 */
	@ModelNodeBinding(detypedName = "capacity-factor")
	public Double capacityFactor() {
		return this.capacityFactor;
	}

	/**
	 * Controls the proportion of entries that will reside on the local node,
	 * compared to the other nodes in the cluster.
	 */
	@SuppressWarnings("unchecked")
	public T capacityFactor(java.lang.Double value) {
		Object oldValue = this.capacityFactor;
		this.capacityFactor = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityFactor", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the consistent hash strategy for the cache.
	 */
	@ModelNodeBinding(detypedName = "consistent-hash-strategy")
	public ConsistentHashStrategy consistentHashStrategy() {
		return this.consistentHashStrategy;
	}

	/**
	 * Defines the consistent hash strategy for the cache.
	 */
	@SuppressWarnings("unchecked")
	public T consistentHashStrategy(ConsistentHashStrategy value) {
		Object oldValue = this.consistentHashStrategy;
		this.consistentHashStrategy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("consistentHashStrategy", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "elapsed-time")
	public Long elapsedTime() {
		return this.elapsedTime;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T elapsedTime(java.lang.Long value) {
		Object oldValue = this.elapsedTime;
		this.elapsedTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("elapsedTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if
	 * the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if
	 * the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T hitRatio(java.lang.Double value) {
		Object oldValue = this.hitRatio;
		this.hitRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hitRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T hits(java.lang.Long value) {
		Object oldValue = this.hits;
		this.hits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hits", oldValue, value);
		return (T) this;
	}

	/**
	 * If enabled, entries will be indexed when they are added to the cache.
	 * Indexes will be updated as entries change or are removed.
	 */
	@ModelNodeBinding(detypedName = "indexing")
	public String indexing() {
		return this.indexing;
	}

	/**
	 * If enabled, entries will be indexed when they are added to the cache.
	 * Indexes will be updated as entries change or are removed.
	 */
	@SuppressWarnings("unchecked")
	public T indexing(java.lang.String value) {
		Object oldValue = this.indexing;
		this.indexing = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("indexing", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to control indexing behaviour
	 */
	@ModelNodeBinding(detypedName = "indexing-properties")
	public Map indexingProperties() {
		return this.indexingProperties;
	}

	/**
	 * Properties to control indexing behaviour
	 */
	@SuppressWarnings("unchecked")
	public T indexingProperties(java.util.Map value) {
		Object oldValue = this.indexingProperties;
		this.indexingProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("indexingProperties", oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to control indexing behaviour
	 */
	@SuppressWarnings("unchecked")
	public T indexingProperty(java.lang.String key, java.lang.Object value) {
		if (this.indexingProperties == null) {
			this.indexingProperties = new java.util.HashMap<>();
		}
		this.indexingProperties.put(key, value);
		return (T) this;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T invalidations(java.lang.Long value) {
		Object oldValue = this.invalidations;
		this.invalidations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("invalidations", oldValue, value);
		return (T) this;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(java.lang.String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * Maximum lifespan of an entry placed in the L1 cache. This element
	 * configures the L1 cache behavior in 'distributed' caches instances. In
	 * any other cache modes, this element is ignored.
	 */
	@ModelNodeBinding(detypedName = "l1-lifespan")
	public Long l1Lifespan() {
		return this.l1Lifespan;
	}

	/**
	 * Maximum lifespan of an entry placed in the L1 cache. This element
	 * configures the L1 cache behavior in 'distributed' caches instances. In
	 * any other cache modes, this element is ignored.
	 */
	@SuppressWarnings("unchecked")
	public T l1Lifespan(java.lang.Long value) {
		Object oldValue = this.l1Lifespan;
		this.l1Lifespan = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("l1Lifespan", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not
	 * started.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not
	 * started.
	 */
	@SuppressWarnings("unchecked")
	public T misses(java.lang.Long value) {
		Object oldValue = this.misses;
		this.misses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("misses", oldValue, value);
		return (T) this;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC
	 * for synchronous operation.
	 */
	@ModelNodeBinding(detypedName = "mode")
	public Mode mode() {
		return this.mode;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC
	 * for synchronous operation.
	 */
	@SuppressWarnings("unchecked")
	public T mode(Mode value) {
		Object oldValue = this.mode;
		this.mode = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mode", oldValue, value);
		return (T) this;
	}

	/**
	 * The module whose class loader should be used when building this cache's
	 * configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache's
	 * configuration.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache
	 * is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache
	 * is not started.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfEntries(java.lang.Integer value) {
		Object oldValue = this.numberOfEntries;
		this.numberOfEntries = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfEntries", oldValue, value);
		return (T) this;
	}

	/**
	 * Number of cluster-wide replicas for each cache entry.
	 */
	@ModelNodeBinding(detypedName = "owners")
	public Integer owners() {
		return this.owners;
	}

	/**
	 * Number of cluster-wide replicas for each cache entry.
	 */
	@SuppressWarnings("unchecked")
	public T owners(java.lang.Integer value) {
		Object oldValue = this.owners;
		this.owners = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("owners", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to
	 * a cache store). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to
	 * a cache store). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T passivations(java.lang.Long value) {
		Object oldValue = this.passivations;
		this.passivations = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("passivations", oldValue, value);
		return (T) this;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread
	 * used to flush the replication queue runs. This should be a positive
	 * integer which represents thread wakeup time in milliseconds.
	 */
	@ModelNodeBinding(detypedName = "queue-flush-interval")
	public Long queueFlushInterval() {
		return this.queueFlushInterval;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread
	 * used to flush the replication queue runs. This should be a positive
	 * integer which represents thread wakeup time in milliseconds.
	 */
	@SuppressWarnings("unchecked")
	public T queueFlushInterval(java.lang.Long value) {
		Object oldValue = this.queueFlushInterval;
		this.queueFlushInterval = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueFlushInterval", oldValue, value);
		return (T) this;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the
	 * queue when it reaches a specific threshold.
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the
	 * queue when it reaches a specific threshold.
	 */
	@SuppressWarnings("unchecked")
	public T queueSize(java.lang.Integer value) {
		Object oldValue = this.queueSize;
		this.queueSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queueSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null
	 * if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null
	 * if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T readWriteRatio(java.lang.Double value) {
		Object oldValue = this.readWriteRatio;
		this.readWriteRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("readWriteRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when
	 * making a remote call, after which the call is aborted and an exception is
	 * thrown.
	 */
	@ModelNodeBinding(detypedName = "remote-timeout")
	public Long remoteTimeout() {
		return this.remoteTimeout;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when
	 * making a remote call, after which the call is aborted and an exception is
	 * thrown.
	 */
	@SuppressWarnings("unchecked")
	public T remoteTimeout(java.lang.Long value) {
		Object oldValue = this.remoteTimeout;
		this.remoteTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("remoteTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache
	 * is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache
	 * is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeHits(java.lang.Long value) {
		Object oldValue = this.removeHits;
		this.removeHits = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removeHits", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache
	 * is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache
	 * is not started.
	 */
	@SuppressWarnings("unchecked")
	public T removeMisses(java.lang.Long value) {
		Object oldValue = this.removeMisses;
		this.removeMisses = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("removeMisses", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of times data was replicated around the cluster. May return
	 * null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "replication-count")
	public Long replicationCount() {
		return this.replicationCount;
	}

	/**
	 * The number of times data was replicated around the cluster. May return
	 * null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T replicationCount(java.lang.Long value) {
		Object oldValue = this.replicationCount;
		this.replicationCount = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("replicationCount", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of data replication failures. May return null if the cache is
	 * not started.
	 */
	@ModelNodeBinding(detypedName = "replication-failures")
	public Long replicationFailures() {
		return this.replicationFailures;
	}

	/**
	 * The number of data replication failures. May return null if the cache is
	 * not started.
	 */
	@SuppressWarnings("unchecked")
	public T replicationFailures(java.lang.Long value) {
		Object oldValue = this.replicationFailures;
		this.replicationFailures = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("replicationFailures", oldValue, value);
		return (T) this;
	}

	/**
	 * Controls the number of hash space segments which is the granularity for
	 * key distribution in the cluster. Value must be strictly positive.
	 */
	@ModelNodeBinding(detypedName = "segments")
	public Integer segments() {
		return this.segments;
	}

	/**
	 * Controls the number of hash space segments which is the granularity for
	 * key distribution in the cluster. Value must be strictly positive.
	 */
	@SuppressWarnings("unchecked")
	public T segments(java.lang.Integer value) {
		Object oldValue = this.segments;
		this.segments = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("segments", oldValue, value);
		return (T) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of cache attribute put operations. May return null if the
	 * cache is not started.
	 */
	@ModelNodeBinding(detypedName = "stores")
	public Long stores() {
		return this.stores;
	}

	/**
	 * The number of cache attribute put operations. May return null if the
	 * cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T stores(java.lang.Long value) {
		Object oldValue = this.stores;
		this.stores = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("stores", oldValue, value);
		return (T) this;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May
	 * return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "success-ratio")
	public Double successRatio() {
		return this.successRatio;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May
	 * return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T successRatio(java.lang.Double value) {
		Object oldValue = this.successRatio;
		this.successRatio = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("successRatio", oldValue, value);
		return (T) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the
	 * cache is not started.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the
	 * cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public T timeSinceReset(java.lang.Long value) {
		Object oldValue = this.timeSinceReset;
		this.timeSinceReset = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("timeSinceReset", oldValue, value);
		return (T) this;
	}
}