package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A currently established SSL session.
 */
@Addresses({"/subsystem=elytron/client-ssl-context=*/ssl-session=*",
		"/subsystem=elytron/server-ssl-context=*/ssl-session=*"})
@ResourceType("ssl-session")
public class SslSession<T extends SslSession<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The application buffer size as reported by the SSLSession.")
	private Integer applicationBufferSize;
	@AttributeDocumentation("The selected cipher suite as reported by the SSLSession.")
	private String cipherSuite;
	@AttributeDocumentation("The creation time as reported by the SSLSession.")
	private String creationTime;
	@AttributeDocumentation("The last accessed time as reported by the SSLSession.")
	private String lastAccessedTime;
	@AttributeDocumentation("The local certificates from the SSLSession.")
	private List<java.util.Map> localCertificates;
	@AttributeDocumentation("The local principal as reported by the SSLSession.")
	private String localPrincipal;
	@AttributeDocumentation("The packet buffer size as reported by the SSLSession.")
	private Integer packetBufferSize;
	@AttributeDocumentation("The peer certificates from the SSLSession.")
	private List<java.util.Map> peerCertificates;
	@AttributeDocumentation("The peer host as reported by the SSLSession.")
	private String peerHost;
	@AttributeDocumentation("The peer port as reported by the SSLSession.")
	private Integer peerPort;
	@AttributeDocumentation("The peer principal as reported by the SSLSession.")
	private String peerPrincipal;
	@AttributeDocumentation("The protocol as reported by the SSLSession.")
	private String protocol;
	@AttributeDocumentation("The validity of the session as reported by the SSLSession.")
	private Boolean valid;

	public SslSession(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The application buffer size as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "application-buffer-size")
	public Integer applicationBufferSize() {
		return this.applicationBufferSize;
	}

	/**
	 * The application buffer size as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T applicationBufferSize(java.lang.Integer value) {
		Object oldValue = this.applicationBufferSize;
		this.applicationBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("applicationBufferSize", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The selected cipher suite as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "cipher-suite")
	public String cipherSuite() {
		return this.cipherSuite;
	}

	/**
	 * The selected cipher suite as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T cipherSuite(java.lang.String value) {
		Object oldValue = this.cipherSuite;
		this.cipherSuite = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cipherSuite", oldValue, value);
		return (T) this;
	}

	/**
	 * The creation time as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "creation-time")
	public String creationTime() {
		return this.creationTime;
	}

	/**
	 * The creation time as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T creationTime(java.lang.String value) {
		Object oldValue = this.creationTime;
		this.creationTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("creationTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The last accessed time as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "last-accessed-time")
	public String lastAccessedTime() {
		return this.lastAccessedTime;
	}

	/**
	 * The last accessed time as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T lastAccessedTime(java.lang.String value) {
		Object oldValue = this.lastAccessedTime;
		this.lastAccessedTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("lastAccessedTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The local certificates from the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "local-certificates")
	public List<Map> localCertificates() {
		return this.localCertificates;
	}

	/**
	 * The local certificates from the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T localCertificates(java.util.List<java.util.Map> value) {
		Object oldValue = this.localCertificates;
		this.localCertificates = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("localCertificates", oldValue, value);
		return (T) this;
	}

	/**
	 * The local certificates from the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T localCertificate(java.util.Map value) {
		if (this.localCertificates == null) {
			this.localCertificates = new java.util.ArrayList<>();
		}
		this.localCertificates.add(value);
		return (T) this;
	}

	/**
	 * The local certificates from the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T localCertificates(java.util.Map... args) {
		localCertificates(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The local principal as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "local-principal")
	public String localPrincipal() {
		return this.localPrincipal;
	}

	/**
	 * The local principal as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T localPrincipal(java.lang.String value) {
		Object oldValue = this.localPrincipal;
		this.localPrincipal = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("localPrincipal", oldValue, value);
		return (T) this;
	}

	/**
	 * The packet buffer size as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "packet-buffer-size")
	public Integer packetBufferSize() {
		return this.packetBufferSize;
	}

	/**
	 * The packet buffer size as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T packetBufferSize(java.lang.Integer value) {
		Object oldValue = this.packetBufferSize;
		this.packetBufferSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("packetBufferSize", oldValue, value);
		return (T) this;
	}

	/**
	 * The peer certificates from the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "peer-certificates")
	public List<Map> peerCertificates() {
		return this.peerCertificates;
	}

	/**
	 * The peer certificates from the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T peerCertificates(java.util.List<java.util.Map> value) {
		Object oldValue = this.peerCertificates;
		this.peerCertificates = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("peerCertificates", oldValue, value);
		return (T) this;
	}

	/**
	 * The peer certificates from the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T peerCertificate(java.util.Map value) {
		if (this.peerCertificates == null) {
			this.peerCertificates = new java.util.ArrayList<>();
		}
		this.peerCertificates.add(value);
		return (T) this;
	}

	/**
	 * The peer certificates from the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T peerCertificates(java.util.Map... args) {
		peerCertificates(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The peer host as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "peer-host")
	public String peerHost() {
		return this.peerHost;
	}

	/**
	 * The peer host as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T peerHost(java.lang.String value) {
		Object oldValue = this.peerHost;
		this.peerHost = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("peerHost", oldValue, value);
		return (T) this;
	}

	/**
	 * The peer port as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "peer-port")
	public Integer peerPort() {
		return this.peerPort;
	}

	/**
	 * The peer port as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T peerPort(java.lang.Integer value) {
		Object oldValue = this.peerPort;
		this.peerPort = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("peerPort", oldValue, value);
		return (T) this;
	}

	/**
	 * The peer principal as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "peer-principal")
	public String peerPrincipal() {
		return this.peerPrincipal;
	}

	/**
	 * The peer principal as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T peerPrincipal(java.lang.String value) {
		Object oldValue = this.peerPrincipal;
		this.peerPrincipal = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("peerPrincipal", oldValue, value);
		return (T) this;
	}

	/**
	 * The protocol as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The protocol as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T protocol(java.lang.String value) {
		Object oldValue = this.protocol;
		this.protocol = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("protocol", oldValue, value);
		return (T) this;
	}

	/**
	 * The validity of the session as reported by the SSLSession.
	 */
	@ModelNodeBinding(detypedName = "valid")
	public Boolean valid() {
		return this.valid;
	}

	/**
	 * The validity of the session as reported by the SSLSession.
	 */
	@SuppressWarnings("unchecked")
	public T valid(java.lang.Boolean value) {
		Object oldValue = this.valid;
		this.valid = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("valid", oldValue, value);
		return (T) this;
	}
}