package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * Definition of a simple RoleDecoder that takes a single attribute and maps it
 * directly to roles.
 */
@Address("/subsystem=elytron/simple-role-decoder=*")
@ResourceType("simple-role-decoder")
public class SimpleRoleDecoder<T extends SimpleRoleDecoder<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the attribute from the identity to map directly to roles.")
	private String attribute;

	public SimpleRoleDecoder(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the attribute from the identity to map directly to roles.
	 */
	@ModelNodeBinding(detypedName = "attribute")
	public String attribute() {
		return this.attribute;
	}

	/**
	 * The name of the attribute from the identity to map directly to roles.
	 */
	@SuppressWarnings("unchecked")
	public T attribute(java.lang.String value) {
		Object oldValue = this.attribute;
		this.attribute = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("attribute", oldValue, value);
		return (T) this;
	}
}