package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.SecurityDomain;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface SecurityDomainConsumer<T extends SecurityDomain<T>> {

	/**
	 * Configure a pre-constructed instance of SecurityDomain resource
	 * 
	 * @parameter Instance of SecurityDomain to configure
	 * @return nothing
	 */
	void accept(T value);

	default SecurityDomainConsumer<T> andThen(SecurityDomainConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}