package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Map;
import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * A definition for a Provider loader.
 */
@Address("/subsystem=elytron/provider-loader=*")
@ResourceType("provider-loader")
public class ProviderLoader<T extends ProviderLoader<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The list of providers loaded by this provider loader.")
	private List<java.util.Map> loadedProviders;
	@AttributeDocumentation("The fully qualified class names of the providers to load, these are loaded after the service-loader discovered providers and duplicates will be skipped.")
	private List<String> classNames;
	@AttributeDocumentation("The name of the module to load the provider from.")
	private String module;
	@AttributeDocumentation("An argument to be passed into the constructor as the Provider is instantiated.")
	private String argument;
	@AttributeDocumentation("The key/value configuration to be passed to the Provider to initialise it.")
	private Map configuration;
	@AttributeDocumentation("The path of the file to use to initialise the providers.")
	private String path;
	@AttributeDocumentation("The base path of the configuration file.")
	private String relativeTo;

	public ProviderLoader(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The list of providers loaded by this provider loader.
	 */
	@ModelNodeBinding(detypedName = "loaded-providers")
	public List<Map> loadedProviders() {
		return this.loadedProviders;
	}

	/**
	 * The list of providers loaded by this provider loader.
	 */
	@SuppressWarnings("unchecked")
	public T loadedProviders(java.util.List<java.util.Map> value) {
		Object oldValue = this.loadedProviders;
		this.loadedProviders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("loadedProviders", oldValue, value);
		return (T) this;
	}

	/**
	 * The list of providers loaded by this provider loader.
	 */
	@SuppressWarnings("unchecked")
	public T loadedProvider(java.util.Map value) {
		if (this.loadedProviders == null) {
			this.loadedProviders = new java.util.ArrayList<>();
		}
		this.loadedProviders.add(value);
		return (T) this;
	}

	/**
	 * The list of providers loaded by this provider loader.
	 */
	@SuppressWarnings("unchecked")
	public T loadedProviders(java.util.Map... args) {
		loadedProviders(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The fully qualified class names of the providers to load, these are
	 * loaded after the service-loader discovered providers and duplicates will
	 * be skipped.
	 */
	@ModelNodeBinding(detypedName = "class-names")
	public List<String> classNames() {
		return this.classNames;
	}

	/**
	 * The fully qualified class names of the providers to load, these are
	 * loaded after the service-loader discovered providers and duplicates will
	 * be skipped.
	 */
	@SuppressWarnings("unchecked")
	public T classNames(java.util.List<String> value) {
		Object oldValue = this.classNames;
		this.classNames = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("classNames", oldValue, value);
		return (T) this;
	}

	/**
	 * The fully qualified class names of the providers to load, these are
	 * loaded after the service-loader discovered providers and duplicates will
	 * be skipped.
	 */
	@SuppressWarnings("unchecked")
	public T className(String value) {
		if (this.classNames == null) {
			this.classNames = new java.util.ArrayList<>();
		}
		this.classNames.add(value);
		return (T) this;
	}

	/**
	 * The fully qualified class names of the providers to load, these are
	 * loaded after the service-loader discovered providers and duplicates will
	 * be skipped.
	 */
	@SuppressWarnings("unchecked")
	public T classNames(String... args) {
		classNames(Arrays.stream(args).collect(Collectors.toList()));
		return (T) this;
	}

	/**
	 * The name of the module to load the provider from.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The name of the module to load the provider from.
	 */
	@SuppressWarnings("unchecked")
	public T module(java.lang.String value) {
		Object oldValue = this.module;
		this.module = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("module", oldValue, value);
		return (T) this;
	}

	/**
	 * An argument to be passed into the constructor as the Provider is
	 * instantiated.
	 */
	@ModelNodeBinding(detypedName = "argument")
	public String argument() {
		return this.argument;
	}

	/**
	 * An argument to be passed into the constructor as the Provider is
	 * instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T argument(java.lang.String value) {
		Object oldValue = this.argument;
		this.argument = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("argument", oldValue, value);
		return (T) this;
	}

	/**
	 * The key/value configuration to be passed to the Provider to initialise
	 * it.
	 */
	@ModelNodeBinding(detypedName = "configuration")
	public Map configuration() {
		return this.configuration;
	}

	/**
	 * The key/value configuration to be passed to the Provider to initialise
	 * it.
	 */
	@SuppressWarnings("unchecked")
	public T configuration(java.util.Map value) {
		Object oldValue = this.configuration;
		this.configuration = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("configuration", oldValue, value);
		return (T) this;
	}

	/**
	 * The key/value configuration to be passed to the Provider to initialise
	 * it.
	 */
	@SuppressWarnings("unchecked")
	public T configuration(java.lang.String key, java.lang.Object value) {
		if (this.configuration == null) {
			this.configuration = new java.util.HashMap<>();
		}
		this.configuration.put(key, value);
		return (T) this;
	}

	/**
	 * The path of the file to use to initialise the providers.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * The path of the file to use to initialise the providers.
	 */
	@SuppressWarnings("unchecked")
	public T path(java.lang.String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * The base path of the configuration file.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * The base path of the configuration file.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}
}