package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.Policy;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface PolicyConsumer<T extends Policy<T>> {

	/**
	 * Configure a pre-constructed instance of Policy resource
	 * 
	 * @parameter Instance of Policy to configure
	 * @return nothing
	 */
	void accept(T value);

	default PolicyConsumer<T> andThen(PolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}