package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.MappedRegexRealmMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface MappedRegexRealmMapperConsumer<T extends MappedRegexRealmMapper<T>> {

	/**
	 * Configure a pre-constructed instance of MappedRegexRealmMapper resource
	 * 
	 * @parameter Instance of MappedRegexRealmMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default MappedRegexRealmMapperConsumer<T> andThen(
			MappedRegexRealmMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}