package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A security realm definition backed by a key store.
 */
@Address("/subsystem=elytron/key-store-realm=*")
@ResourceType("key-store-realm")
public class KeyStoreRealm<T extends KeyStoreRealm<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Reference to the KeyStore that should be used to back this security realm.")
	private String keyStore;

	public KeyStoreRealm(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Reference to the KeyStore that should be used to back this security
	 * realm.
	 */
	@ModelNodeBinding(detypedName = "key-store")
	public String keyStore() {
		return this.keyStore;
	}

	/**
	 * Reference to the KeyStore that should be used to back this security
	 * realm.
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(java.lang.String value) {
		Object oldValue = this.keyStore;
		this.keyStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyStore", oldValue, value);
		return (T) this;
	}
}