package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;

/**
 * A key manager definition for creating the KeyManager as used to create an
 * SSLContext.
 */
@Address("/subsystem=elytron/key-manager=*")
@ResourceType("key-manager")
public class KeyManager<T extends KeyManager<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The name of the algorithm to use to create the underlying KeyManagerFactory.")
	private String algorithm;
	@AttributeDocumentation("A filter to apply to the aliases returned from the KeyStore, can either be a comma separated list of aliases to return or one of the following formats ALL:-alias1:-alias2, NONE:+alias1:+alias2")
	private String aliasFilter;
	@AttributeDocumentation("The credential reference to decrypt KeyStore item. (Not a password of the KeyStore.)")
	private Map credentialReference;
	@AttributeDocumentation("Reference to the KeyStore to use to initialise the underlying KeyManagerFactory.")
	private String keyStore;
	@AttributeDocumentation("The name of the provider to use to create the underlying KeyManagerFactory.")
	private String providerName;
	@AttributeDocumentation("Reference to obtain the Provider[] to use when creating the underlying KeyManagerFactory.")
	private String providers;

	public KeyManager(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the algorithm to use to create the underlying
	 * KeyManagerFactory.
	 */
	@ModelNodeBinding(detypedName = "algorithm")
	public String algorithm() {
		return this.algorithm;
	}

	/**
	 * The name of the algorithm to use to create the underlying
	 * KeyManagerFactory.
	 */
	@SuppressWarnings("unchecked")
	public T algorithm(java.lang.String value) {
		Object oldValue = this.algorithm;
		this.algorithm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("algorithm", oldValue, value);
		return (T) this;
	}

	/**
	 * A filter to apply to the aliases returned from the KeyStore, can either
	 * be a comma separated list of aliases to return or one of the following
	 * formats ALL:-alias1:-alias2, NONE:+alias1:+alias2
	 */
	@ModelNodeBinding(detypedName = "alias-filter")
	public String aliasFilter() {
		return this.aliasFilter;
	}

	/**
	 * A filter to apply to the aliases returned from the KeyStore, can either
	 * be a comma separated list of aliases to return or one of the following
	 * formats ALL:-alias1:-alias2, NONE:+alias1:+alias2
	 */
	@SuppressWarnings("unchecked")
	public T aliasFilter(java.lang.String value) {
		Object oldValue = this.aliasFilter;
		this.aliasFilter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("aliasFilter", oldValue, value);
		return (T) this;
	}

	/**
	 * The credential reference to decrypt KeyStore item. (Not a password of the
	 * KeyStore.)
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * The credential reference to decrypt KeyStore item. (Not a password of the
	 * KeyStore.)
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * The credential reference to decrypt KeyStore item. (Not a password of the
	 * KeyStore.)
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * Reference to the KeyStore to use to initialise the underlying
	 * KeyManagerFactory.
	 */
	@ModelNodeBinding(detypedName = "key-store")
	public String keyStore() {
		return this.keyStore;
	}

	/**
	 * Reference to the KeyStore to use to initialise the underlying
	 * KeyManagerFactory.
	 */
	@SuppressWarnings("unchecked")
	public T keyStore(java.lang.String value) {
		Object oldValue = this.keyStore;
		this.keyStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("keyStore", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the provider to use to create the underlying
	 * KeyManagerFactory.
	 */
	@ModelNodeBinding(detypedName = "provider-name")
	public String providerName() {
		return this.providerName;
	}

	/**
	 * The name of the provider to use to create the underlying
	 * KeyManagerFactory.
	 */
	@SuppressWarnings("unchecked")
	public T providerName(java.lang.String value) {
		Object oldValue = this.providerName;
		this.providerName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providerName", oldValue, value);
		return (T) this;
	}

	/**
	 * Reference to obtain the Provider[] to use when creating the underlying
	 * KeyManagerFactory.
	 */
	@ModelNodeBinding(detypedName = "providers")
	public String providers() {
		return this.providers;
	}

	/**
	 * Reference to obtain the Provider[] to use when creating the underlying
	 * KeyManagerFactory.
	 */
	@SuppressWarnings("unchecked")
	public T providers(java.lang.String value) {
		Object oldValue = this.providers;
		this.providers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providers", oldValue, value);
		return (T) this;
	}
}