package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.FileAuditLog;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface FileAuditLogConsumer<T extends FileAuditLog<T>> {

	/**
	 * Configure a pre-constructed instance of FileAuditLog resource
	 * 
	 * @parameter Instance of FileAuditLog to configure
	 * @return nothing
	 */
	void accept(T value);

	default FileAuditLogConsumer<T> andThen(FileAuditLogConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}