package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;
import org.wildfly.swarm.config.elytron.State;

/**
 * Credential store to keep alias for sensitive information such as passwords
 * for external services.
 */
@Address("/subsystem=elytron/credential-store=*")
@ResourceType("credential-store")
public class CredentialStore<T extends CredentialStore<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("Credential reference to be used to create protection parameter.")
	private Map credentialReference;
	@AttributeDocumentation("The state of the underlying service that represents this credential store at runtime.")
	private State state;
	@AttributeDocumentation("A reference to a previously defined path that the file name is relative to.")
	private String relativeTo;
	@AttributeDocumentation("Specifies whether credential store should create storage when it doesn't exist.")
	private Boolean create;
	@AttributeDocumentation("Map of credentials store implementation specific properties.")
	private Map implementationProperties;
	@AttributeDocumentation("File name of credential store storage.")
	private String location;
	@AttributeDocumentation("Specifies whether credential store is modifiable.")
	private Boolean modifiable;
	@AttributeDocumentation("The name of the providers defined within the subsystem to obtain the Providers to search for the one that can create the required JCA objects within credential store. This is valid only for key-store based CredentialStore. If this is not specified then the global list of Providers is used instead.")
	private String otherProviders;
	@AttributeDocumentation("The name of the provider to use to instantiate the CredentialStoreSpi. If the provider is not specified then the first provider found that can create an instance of the specified 'type' will be used.")
	private String providerName;
	@AttributeDocumentation("The name of the providers defined within the subsystem to obtain the Providers to search for the one that can create the required CredentialStore type. If this is not specified then the global list of Providers is used instead.")
	private String providers;
	@AttributeDocumentation("The credential store type, e.g. KeyStoreCredentialStore.")
	private String type;

	public CredentialStore(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Credential reference to be used to create protection parameter.
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * Credential reference to be used to create protection parameter.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * Credential reference to be used to create protection parameter.
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The state of the underlying service that represents this credential store
	 * at runtime.
	 */
	@ModelNodeBinding(detypedName = "state")
	public State state() {
		return this.state;
	}

	/**
	 * The state of the underlying service that represents this credential store
	 * at runtime.
	 */
	@SuppressWarnings("unchecked")
	public T state(State value) {
		Object oldValue = this.state;
		this.state = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("state", oldValue, value);
		return (T) this;
	}

	/**
	 * A reference to a previously defined path that the file name is relative
	 * to.
	 */
	@ModelNodeBinding(detypedName = "relative-to")
	public String relativeTo() {
		return this.relativeTo;
	}

	/**
	 * A reference to a previously defined path that the file name is relative
	 * to.
	 */
	@SuppressWarnings("unchecked")
	public T relativeTo(java.lang.String value) {
		Object oldValue = this.relativeTo;
		this.relativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("relativeTo", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies whether credential store should create storage when it doesn't
	 * exist.
	 */
	@ModelNodeBinding(detypedName = "create")
	public Boolean create() {
		return this.create;
	}

	/**
	 * Specifies whether credential store should create storage when it doesn't
	 * exist.
	 */
	@SuppressWarnings("unchecked")
	public T create(java.lang.Boolean value) {
		Object oldValue = this.create;
		this.create = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("create", oldValue, value);
		return (T) this;
	}

	/**
	 * Map of credentials store implementation specific properties.
	 */
	@ModelNodeBinding(detypedName = "implementation-properties")
	public Map implementationProperties() {
		return this.implementationProperties;
	}

	/**
	 * Map of credentials store implementation specific properties.
	 */
	@SuppressWarnings("unchecked")
	public T implementationProperties(java.util.Map value) {
		Object oldValue = this.implementationProperties;
		this.implementationProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("implementationProperties", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Map of credentials store implementation specific properties.
	 */
	@SuppressWarnings("unchecked")
	public T implementationProperty(java.lang.String key, java.lang.Object value) {
		if (this.implementationProperties == null) {
			this.implementationProperties = new java.util.HashMap<>();
		}
		this.implementationProperties.put(key, value);
		return (T) this;
	}

	/**
	 * File name of credential store storage.
	 */
	@ModelNodeBinding(detypedName = "location")
	public String location() {
		return this.location;
	}

	/**
	 * File name of credential store storage.
	 */
	@SuppressWarnings("unchecked")
	public T location(java.lang.String value) {
		Object oldValue = this.location;
		this.location = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("location", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies whether credential store is modifiable.
	 */
	@ModelNodeBinding(detypedName = "modifiable")
	public Boolean modifiable() {
		return this.modifiable;
	}

	/**
	 * Specifies whether credential store is modifiable.
	 */
	@SuppressWarnings("unchecked")
	public T modifiable(java.lang.Boolean value) {
		Object oldValue = this.modifiable;
		this.modifiable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("modifiable", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the providers defined within the subsystem to obtain the
	 * Providers to search for the one that can create the required JCA objects
	 * within credential store. This is valid only for key-store based
	 * CredentialStore. If this is not specified then the global list of
	 * Providers is used instead.
	 */
	@ModelNodeBinding(detypedName = "other-providers")
	public String otherProviders() {
		return this.otherProviders;
	}

	/**
	 * The name of the providers defined within the subsystem to obtain the
	 * Providers to search for the one that can create the required JCA objects
	 * within credential store. This is valid only for key-store based
	 * CredentialStore. If this is not specified then the global list of
	 * Providers is used instead.
	 */
	@SuppressWarnings("unchecked")
	public T otherProviders(java.lang.String value) {
		Object oldValue = this.otherProviders;
		this.otherProviders = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("otherProviders", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the provider to use to instantiate the CredentialStoreSpi. If
	 * the provider is not specified then the first provider found that can
	 * create an instance of the specified 'type' will be used.
	 */
	@ModelNodeBinding(detypedName = "provider-name")
	public String providerName() {
		return this.providerName;
	}

	/**
	 * The name of the provider to use to instantiate the CredentialStoreSpi. If
	 * the provider is not specified then the first provider found that can
	 * create an instance of the specified 'type' will be used.
	 */
	@SuppressWarnings("unchecked")
	public T providerName(java.lang.String value) {
		Object oldValue = this.providerName;
		this.providerName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providerName", oldValue, value);
		return (T) this;
	}

	/**
	 * The name of the providers defined within the subsystem to obtain the
	 * Providers to search for the one that can create the required
	 * CredentialStore type. If this is not specified then the global list of
	 * Providers is used instead.
	 */
	@ModelNodeBinding(detypedName = "providers")
	public String providers() {
		return this.providers;
	}

	/**
	 * The name of the providers defined within the subsystem to obtain the
	 * Providers to search for the one that can create the required
	 * CredentialStore type. If this is not specified then the global list of
	 * Providers is used instead.
	 */
	@SuppressWarnings("unchecked")
	public T providers(java.lang.String value) {
		Object oldValue = this.providers;
		this.providers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("providers", oldValue, value);
		return (T) this;
	}

	/**
	 * The credential store type, e.g. KeyStoreCredentialStore.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The credential store type, e.g. KeyStoreCredentialStore.
	 */
	@SuppressWarnings("unchecked")
	public T type(java.lang.String value) {
		Object oldValue = this.type;
		this.type = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("type", oldValue, value);
		return (T) this;
	}
}