package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.ConcatenatingPrincipalDecoder;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConcatenatingPrincipalDecoderConsumer<T extends ConcatenatingPrincipalDecoder<T>> {

	/**
	 * Configure a pre-constructed instance of ConcatenatingPrincipalDecoder
	 * resource
	 * 
	 * @parameter Instance of ConcatenatingPrincipalDecoder to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConcatenatingPrincipalDecoderConsumer<T> andThen(
			ConcatenatingPrincipalDecoderConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}