package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * A role mapper definition for a role mapper that adds a suffix to each
 * provided.
 */
@Address("/subsystem=elytron/add-suffix-role-mapper=*")
@ResourceType("add-suffix-role-mapper")
public class AddSuffixRoleMapper<T extends AddSuffixRoleMapper<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	@AttributeDocumentation("The suffix to add to each role.")
	private String suffix;

	public AddSuffixRoleMapper(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The suffix to add to each role.
	 */
	@ModelNodeBinding(detypedName = "suffix")
	public String suffix() {
		return this.suffix;
	}

	/**
	 * The suffix to add to each role.
	 */
	@SuppressWarnings("unchecked")
	public T suffix(java.lang.String value) {
		Object oldValue = this.suffix;
		this.suffix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("suffix", oldValue, value);
		return (T) this;
	}
}