package org.wildfly.swarm.config.elytron;

import org.wildfly.swarm.config.elytron.AddPrefixRoleMapper;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface AddPrefixRoleMapperConsumer<T extends AddPrefixRoleMapper<T>> {

	/**
	 * Configure a pre-constructed instance of AddPrefixRoleMapper resource
	 * 
	 * @parameter Instance of AddPrefixRoleMapper to configure
	 * @return nothing
	 */
	void accept(T value);

	default AddPrefixRoleMapperConsumer<T> andThen(
			AddPrefixRoleMapperConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}