package org.wildfly.swarm.config.datasources.data_source;

import org.wildfly.swarm.config.datasources.data_source.ConnectionProperties;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ConnectionPropertiesConsumer<T extends ConnectionProperties<T>> {

	/**
	 * Configure a pre-constructed instance of ConnectionProperties resource
	 * 
	 * @parameter Instance of ConnectionProperties to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConnectionPropertiesConsumer<T> andThen(
			ConnectionPropertiesConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}