package org.wildfly.swarm.config.datasources;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.datasources.data_source.ConnectionPropertiesConsumer;
import org.wildfly.swarm.config.datasources.data_source.ConnectionPropertiesSupplier;
import org.wildfly.swarm.config.datasources.data_source.ConnectionProperties;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.Arrays;
import org.wildfly.swarm.config.datasources.FlushStrategy;

/**
 * A JDBC data-source configuration
 */
@Address("/subsystem=datasources/data-source=*")
@ResourceType("data-source")
public class DataSource<T extends DataSource<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private DataSourceResources subresources = new DataSourceResources();
	@AttributeDocumentation("The allocation retry element indicates the number of times that allocating a connection should be tried before throwing an exception")
	private Integer allocationRetry;
	@AttributeDocumentation("The allocation retry wait millis element specifies the amount of time, in milliseconds, to wait between retrying to allocate a connection")
	private Long allocationRetryWaitMillis;
	@AttributeDocumentation("Specifies if multiple users will access the datasource through the getConnection(user, password) method and hence if the internal pool type should account for that")
	private Boolean allowMultipleUsers;
	@AttributeDocumentation("The Elytron authentication context which defines the javax.security.auth.Subject that is used to distinguish connections in the pool.")
	private String authenticationContext;
	@AttributeDocumentation("An element to specify that connections should be validated on a background thread versus being validated prior to use. Changing this value can be done only on disabled datasource,  requires a server restart otherwise.")
	private Boolean backgroundValidation;
	@AttributeDocumentation("The background-validation-millis element specifies the amount of time, in milliseconds, that background validation will run. Changing this value can be done only on disabled datasource,  requires a server restart otherwise")
	private Long backgroundValidationMillis;
	@AttributeDocumentation("The blocking-timeout-millis element specifies the maximum time, in milliseconds, to block while waiting for a connection before throwing an exception. Note that this blocks only while waiting for locking a connection, and will never throw an exception if creating a new connection takes an inordinately long time")
	private Long blockingTimeoutWaitMillis;
	@AttributeDocumentation("Class defining the policy for decrementing connections in the pool")
	private String capacityDecrementerClass;
	@AttributeDocumentation("Properties to be injected in class defining the policy for decrementing connections in the pool")
	private Map capacityDecrementerProperties;
	@AttributeDocumentation("Class defining the policy for incrementing connections in the pool")
	private String capacityIncrementerClass;
	@AttributeDocumentation("Properties to be injected in class defining the policy for incrementing connections in the pool")
	private Map capacityIncrementerProperties;
	@AttributeDocumentation("Specify an SQL statement to check validity of a pool connection. This may be called when managed connection is obtained from the pool")
	private String checkValidConnectionSql;
	@AttributeDocumentation("Enable the use of CMR. This feature means that a local resource can reliably participate in an XA transaction.")
	private Boolean connectable;
	@AttributeDocumentation("Speciefies class name extending org.jboss.jca.adapters.jdbc.spi.listener.ConnectionListener that provides a possible to listen for connection activation and passivation in order to perform actions before the connection is returned to the application or returned to the pool.")
	private String connectionListenerClass;
	@AttributeDocumentation("Properties to be injected in class specidied in connection-listener-class")
	private Map connectionListenerProperty;
	@AttributeDocumentation("The JDBC driver connection URL")
	private String connectionUrl;
	@AttributeDocumentation("Credential (from Credential Store) to authenticate on data source")
	private Map credentialReference;
	@AttributeDocumentation("The fully qualified name of the JDBC datasource class")
	private String datasourceClass;
	@AttributeDocumentation("The fully qualified name of the JDBC driver class")
	private String driverClass;
	@AttributeDocumentation("Defines the JDBC driver the datasource should use. It is a symbolic name matching the the name of installed driver. In case the driver is deployed as jar, the name is the name of deployment unit")
	private String driverName;
	@AttributeDocumentation("Enables Elytron security for handling authentication of connections. The Elytron authentication-context to be used will be current context if no context is specified (see authentication-context).")
	private Boolean elytronEnabled;
	@AttributeDocumentation("Defines if WildFly/IronJacamar should record enlistment traces")
	private Boolean enlistmentTrace;
	@AttributeDocumentation("An org.jboss.jca.adapters.jdbc.ExceptionSorter that provides an isExceptionFatal(SQLException) method to validate if an exception should broadcast an error")
	private String exceptionSorterClassName;
	@AttributeDocumentation("The exception sorter properties")
	private Map exceptionSorterProperties;
	@AttributeDocumentation("Specifies how the pool should be flush in case of an error.")
	private FlushStrategy flushStrategy;
	@AttributeDocumentation("The idle-timeout-minutes elements specifies the maximum time, in minutes, a connection may be idle before being closed. The actual maximum time depends also on the IdleRemover scan time, which is half of the smallest idle-timeout-minutes value of any pool. Changing this value can be done only on disabled datasource, requires a server restart otherwise.")
	private Long idleTimeoutMinutes;
	@AttributeDocumentation("The initial-pool-size element indicates the initial number of connections a pool should hold.")
	private Integer initialPoolSize;
	@AttributeDocumentation("Specifies the JNDI name for the datasource")
	private String jndiName;
	@AttributeDocumentation("Enable JTA integration")
	private Boolean jta;
	@AttributeDocumentation("The max-pool-size element specifies the maximum number of connections for a pool. No more connections will be created in each sub-pool")
	private Integer maxPoolSize;
	@AttributeDocumentation("Defines the ManagedConnectionPool implementation, f.ex. org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool")
	private String mcp;
	@AttributeDocumentation("The min-pool-size element specifies the minimum number of connections for a pool")
	private Integer minPoolSize;
	@AttributeDocumentation("Specifies an SQL statement to execute whenever a connection is added to the connection pool")
	private String newConnectionSql;
	@AttributeDocumentation("Specifies the password used when creating a new connection")
	private String password;
	@AttributeDocumentation("Defines if pool use should be fair")
	private Boolean poolFair;
	@AttributeDocumentation("Should the pool be prefilled. Changing this value can be done only on disabled datasource, requires a server restart otherwise.")
	private Boolean poolPrefill;
	@AttributeDocumentation("Specifies if the min-pool-size should be considered strictly")
	private Boolean poolUseStrictMin;
	@AttributeDocumentation("The number of prepared statements per connection in an LRU cache")
	private Long preparedStatementsCacheSize;
	@AttributeDocumentation("Any configured query timeout in seconds. If not provided no timeout will be set")
	private Long queryTimeout;
	@AttributeDocumentation("The fully qualified class name of the reauthentication plugin implementation")
	private String reauthPluginClassName;
	@AttributeDocumentation("The properties for the reauthentication plugin")
	private Map reauthPluginProperties;
	@AttributeDocumentation("Specifies the PicketBox security domain which defines the PicketBox javax.security.auth.Subject that are used to distinguish connections in the pool")
	private String securityDomain;
	@AttributeDocumentation("Whether to set the query timeout based on the time remaining until transaction timeout. Any configured query timeout will be used if there is no transaction")
	private Boolean setTxQueryTimeout;
	@AttributeDocumentation("Whether to share prepared statements, i.e. whether asking for same statement twice without closing uses the same underlying prepared statement")
	private Boolean sharePreparedStatements;
	@AttributeDocumentation("Enable spying of SQL statements")
	private Boolean spy;
	@AttributeDocumentation("An org.jboss.jca.adapters.jdbc.StaleConnectionChecker that provides an isStaleConnection(SQLException) method which if it returns true will wrap the exception in an org.jboss.jca.adapters.jdbc.StaleConnectionException")
	private String staleConnectionCheckerClassName;
	@AttributeDocumentation("The stale connection checker properties")
	private Map staleConnectionCheckerProperties;
	@AttributeDocumentation("Define whether runtime statistics are enabled or not.")
	private Boolean statisticsEnabled;
	@AttributeDocumentation("Whether to check for unclosed statements when a connection is returned to the pool, result sets are closed, a statement is closed or return to the prepared statement cache. Valid values are: \"false\" - do not track statements, \"true\" - track statements and result sets and warn when they are not closed, \"nowarn\" - track statements but do not warn about them being unclosed")
	private String trackStatements;
	@AttributeDocumentation("Defines if IronJacamar should track connection handles across transaction boundaries")
	private Boolean tracking;
	@AttributeDocumentation("Set the java.sql.Connection transaction isolation level. Valid values are: TRANSACTION_READ_UNCOMMITTED, TRANSACTION_READ_COMMITTED, TRANSACTION_REPEATABLE_READ, TRANSACTION_SERIALIZABLE and TRANSACTION_NONE. Different values are used to set customLevel using TransactionIsolation#customLevel")
	private String transactionIsolation;
	@AttributeDocumentation("Specifies the delimiter for URLs in connection-url for HA datasources")
	private String urlDelimiter;
	@AttributeDocumentation("A class that implements org.jboss.jca.adapters.jdbc.URLSelectorStrategy")
	private String urlSelectorStrategyClassName;
	@AttributeDocumentation("Enable the use of a cached connection manager")
	private Boolean useCcm;
	@AttributeDocumentation("Whether to fail a connection allocation on the first try if it is invalid (true) or keep trying until the pool is exhausted of all potential connections (false)")
	private Boolean useFastFail;
	@AttributeDocumentation("Setting this to false will bind the datasource into global JNDI")
	private Boolean useJavaContext;
	@AttributeDocumentation("Any configured timeout for internal locks on the resource adapter objects in seconds")
	private Long useTryLock;
	@AttributeDocumentation("Specify the user name used when creating a new connection")
	private String userName;
	@AttributeDocumentation("An org.jboss.jca.adapters.jdbc.ValidConnectionChecker that provides an isValidConnection(Connection) method to validate a connection. If an exception is returned that means the connection is invalid. This overrides the check-valid-connection-sql element")
	private String validConnectionCheckerClassName;
	@AttributeDocumentation("The valid connection checker properties")
	private Map validConnectionCheckerProperties;
	@AttributeDocumentation("The validate-on-match element specifies if connection validation should be done when a connection factory attempts to match a managed connection. This is typically exclusive to the use of background validation")
	private Boolean validateOnMatch;

	public DataSource(java.lang.String key) {
		super();
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public DataSourceResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all ConnectionProperties objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of ConnectionProperties objects.
	 */
	@SuppressWarnings("unchecked")
	public T connectionProperties(java.util.List<ConnectionProperties> value) {
		this.subresources.connectionProperties = value;
		return (T) this;
	}

	/**
	 * Add the ConnectionProperties object to the list of subresources
	 * 
	 * @param value
	 *            The ConnectionProperties to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionProperties(ConnectionProperties value) {
		this.subresources.connectionProperties.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionProperties object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionProperties resource
	 * @param config
	 *            The ConnectionPropertiesConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionProperties(java.lang.String childKey,
			ConnectionPropertiesConsumer consumer) {
		ConnectionProperties<? extends ConnectionProperties> child = new ConnectionProperties<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		connectionProperties(child);
		return (T) this;
	}

	/**
	 * Create and configure a ConnectionProperties object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the ConnectionProperties resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T connectionProperties(java.lang.String childKey) {
		connectionProperties(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied ConnectionProperties object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T connectionProperties(ConnectionPropertiesSupplier supplier) {
		connectionProperties(supplier.get());
		return (T) this;
	}

	/**
	 * Child mutators for DataSource
	 */
	public static class DataSourceResources {
		/**
		 * The connection-properties element allows you to pass in arbitrary
		 * connection properties to the Driver.connect(url, props) method
		 */
		@ResourceDocumentation("The connection-properties element allows you to pass in arbitrary connection properties to the Driver.connect(url, props) method")
		@SubresourceInfo("connectionProperties")
		private List<ConnectionProperties> connectionProperties = new java.util.ArrayList<>();

		/**
		 * Get the list of ConnectionProperties resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<ConnectionProperties> connectionProperties() {
			return this.connectionProperties;
		}

		public ConnectionProperties connectionProperties(java.lang.String key) {
			return this.connectionProperties.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
	}

	/**
	 * The allocation retry element indicates the number of times that
	 * allocating a connection should be tried before throwing an exception
	 */
	@ModelNodeBinding(detypedName = "allocation-retry")
	public Integer allocationRetry() {
		return this.allocationRetry;
	}

	/**
	 * The allocation retry element indicates the number of times that
	 * allocating a connection should be tried before throwing an exception
	 */
	@SuppressWarnings("unchecked")
	public T allocationRetry(java.lang.Integer value) {
		Object oldValue = this.allocationRetry;
		this.allocationRetry = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allocationRetry", oldValue, value);
		return (T) this;
	}

	/**
	 * The allocation retry wait millis element specifies the amount of time, in
	 * milliseconds, to wait between retrying to allocate a connection
	 */
	@ModelNodeBinding(detypedName = "allocation-retry-wait-millis")
	public Long allocationRetryWaitMillis() {
		return this.allocationRetryWaitMillis;
	}

	/**
	 * The allocation retry wait millis element specifies the amount of time, in
	 * milliseconds, to wait between retrying to allocate a connection
	 */
	@SuppressWarnings("unchecked")
	public T allocationRetryWaitMillis(java.lang.Long value) {
		Object oldValue = this.allocationRetryWaitMillis;
		this.allocationRetryWaitMillis = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allocationRetryWaitMillis", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Specifies if multiple users will access the datasource through the
	 * getConnection(user, password) method and hence if the internal pool type
	 * should account for that
	 */
	@ModelNodeBinding(detypedName = "allow-multiple-users")
	public Boolean allowMultipleUsers() {
		return this.allowMultipleUsers;
	}

	/**
	 * Specifies if multiple users will access the datasource through the
	 * getConnection(user, password) method and hence if the internal pool type
	 * should account for that
	 */
	@SuppressWarnings("unchecked")
	public T allowMultipleUsers(java.lang.Boolean value) {
		Object oldValue = this.allowMultipleUsers;
		this.allowMultipleUsers = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("allowMultipleUsers", oldValue, value);
		return (T) this;
	}

	/**
	 * The Elytron authentication context which defines the
	 * javax.security.auth.Subject that is used to distinguish connections in
	 * the pool.
	 */
	@ModelNodeBinding(detypedName = "authentication-context")
	public String authenticationContext() {
		return this.authenticationContext;
	}

	/**
	 * The Elytron authentication context which defines the
	 * javax.security.auth.Subject that is used to distinguish connections in
	 * the pool.
	 */
	@SuppressWarnings("unchecked")
	public T authenticationContext(java.lang.String value) {
		Object oldValue = this.authenticationContext;
		this.authenticationContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("authenticationContext", oldValue,
					value);
		return (T) this;
	}

	/**
	 * An element to specify that connections should be validated on a
	 * background thread versus being validated prior to use. Changing this
	 * value can be done only on disabled datasource, requires a server restart
	 * otherwise.
	 */
	@ModelNodeBinding(detypedName = "background-validation")
	public Boolean backgroundValidation() {
		return this.backgroundValidation;
	}

	/**
	 * An element to specify that connections should be validated on a
	 * background thread versus being validated prior to use. Changing this
	 * value can be done only on disabled datasource, requires a server restart
	 * otherwise.
	 */
	@SuppressWarnings("unchecked")
	public T backgroundValidation(java.lang.Boolean value) {
		Object oldValue = this.backgroundValidation;
		this.backgroundValidation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("backgroundValidation", oldValue, value);
		return (T) this;
	}

	/**
	 * The background-validation-millis element specifies the amount of time, in
	 * milliseconds, that background validation will run. Changing this value
	 * can be done only on disabled datasource, requires a server restart
	 * otherwise
	 */
	@ModelNodeBinding(detypedName = "background-validation-millis")
	public Long backgroundValidationMillis() {
		return this.backgroundValidationMillis;
	}

	/**
	 * The background-validation-millis element specifies the amount of time, in
	 * milliseconds, that background validation will run. Changing this value
	 * can be done only on disabled datasource, requires a server restart
	 * otherwise
	 */
	@SuppressWarnings("unchecked")
	public T backgroundValidationMillis(java.lang.Long value) {
		Object oldValue = this.backgroundValidationMillis;
		this.backgroundValidationMillis = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("backgroundValidationMillis", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The blocking-timeout-millis element specifies the maximum time, in
	 * milliseconds, to block while waiting for a connection before throwing an
	 * exception. Note that this blocks only while waiting for locking a
	 * connection, and will never throw an exception if creating a new
	 * connection takes an inordinately long time
	 */
	@ModelNodeBinding(detypedName = "blocking-timeout-wait-millis")
	public Long blockingTimeoutWaitMillis() {
		return this.blockingTimeoutWaitMillis;
	}

	/**
	 * The blocking-timeout-millis element specifies the maximum time, in
	 * milliseconds, to block while waiting for a connection before throwing an
	 * exception. Note that this blocks only while waiting for locking a
	 * connection, and will never throw an exception if creating a new
	 * connection takes an inordinately long time
	 */
	@SuppressWarnings("unchecked")
	public T blockingTimeoutWaitMillis(java.lang.Long value) {
		Object oldValue = this.blockingTimeoutWaitMillis;
		this.blockingTimeoutWaitMillis = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("blockingTimeoutWaitMillis", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Class defining the policy for decrementing connections in the pool
	 */
	@ModelNodeBinding(detypedName = "capacity-decrementer-class")
	public String capacityDecrementerClass() {
		return this.capacityDecrementerClass;
	}

	/**
	 * Class defining the policy for decrementing connections in the pool
	 */
	@SuppressWarnings("unchecked")
	public T capacityDecrementerClass(java.lang.String value) {
		Object oldValue = this.capacityDecrementerClass;
		this.capacityDecrementerClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityDecrementerClass", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Properties to be injected in class defining the policy for decrementing
	 * connections in the pool
	 */
	@ModelNodeBinding(detypedName = "capacity-decrementer-properties")
	public Map capacityDecrementerProperties() {
		return this.capacityDecrementerProperties;
	}

	/**
	 * Properties to be injected in class defining the policy for decrementing
	 * connections in the pool
	 */
	@SuppressWarnings("unchecked")
	public T capacityDecrementerProperties(java.util.Map value) {
		Object oldValue = this.capacityDecrementerProperties;
		this.capacityDecrementerProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityDecrementerProperties",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to be injected in class defining the policy for decrementing
	 * connections in the pool
	 */
	@SuppressWarnings("unchecked")
	public T capacityDecrementerProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.capacityDecrementerProperties == null) {
			this.capacityDecrementerProperties = new java.util.HashMap<>();
		}
		this.capacityDecrementerProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Class defining the policy for incrementing connections in the pool
	 */
	@ModelNodeBinding(detypedName = "capacity-incrementer-class")
	public String capacityIncrementerClass() {
		return this.capacityIncrementerClass;
	}

	/**
	 * Class defining the policy for incrementing connections in the pool
	 */
	@SuppressWarnings("unchecked")
	public T capacityIncrementerClass(java.lang.String value) {
		Object oldValue = this.capacityIncrementerClass;
		this.capacityIncrementerClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityIncrementerClass", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Properties to be injected in class defining the policy for incrementing
	 * connections in the pool
	 */
	@ModelNodeBinding(detypedName = "capacity-incrementer-properties")
	public Map capacityIncrementerProperties() {
		return this.capacityIncrementerProperties;
	}

	/**
	 * Properties to be injected in class defining the policy for incrementing
	 * connections in the pool
	 */
	@SuppressWarnings("unchecked")
	public T capacityIncrementerProperties(java.util.Map value) {
		Object oldValue = this.capacityIncrementerProperties;
		this.capacityIncrementerProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("capacityIncrementerProperties",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Properties to be injected in class defining the policy for incrementing
	 * connections in the pool
	 */
	@SuppressWarnings("unchecked")
	public T capacityIncrementerProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.capacityIncrementerProperties == null) {
			this.capacityIncrementerProperties = new java.util.HashMap<>();
		}
		this.capacityIncrementerProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Specify an SQL statement to check validity of a pool connection. This may
	 * be called when managed connection is obtained from the pool
	 */
	@ModelNodeBinding(detypedName = "check-valid-connection-sql")
	public String checkValidConnectionSql() {
		return this.checkValidConnectionSql;
	}

	/**
	 * Specify an SQL statement to check validity of a pool connection. This may
	 * be called when managed connection is obtained from the pool
	 */
	@SuppressWarnings("unchecked")
	public T checkValidConnectionSql(java.lang.String value) {
		Object oldValue = this.checkValidConnectionSql;
		this.checkValidConnectionSql = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("checkValidConnectionSql", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Enable the use of CMR. This feature means that a local resource can
	 * reliably participate in an XA transaction.
	 */
	@ModelNodeBinding(detypedName = "connectable")
	public Boolean connectable() {
		return this.connectable;
	}

	/**
	 * Enable the use of CMR. This feature means that a local resource can
	 * reliably participate in an XA transaction.
	 */
	@SuppressWarnings("unchecked")
	public T connectable(java.lang.Boolean value) {
		Object oldValue = this.connectable;
		this.connectable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectable", oldValue, value);
		return (T) this;
	}

	/**
	 * Speciefies class name extending
	 * org.jboss.jca.adapters.jdbc.spi.listener.ConnectionListener that provides
	 * a possible to listen for connection activation and passivation in order
	 * to perform actions before the connection is returned to the application
	 * or returned to the pool.
	 */
	@ModelNodeBinding(detypedName = "connection-listener-class")
	public String connectionListenerClass() {
		return this.connectionListenerClass;
	}

	/**
	 * Speciefies class name extending
	 * org.jboss.jca.adapters.jdbc.spi.listener.ConnectionListener that provides
	 * a possible to listen for connection activation and passivation in order
	 * to perform actions before the connection is returned to the application
	 * or returned to the pool.
	 */
	@SuppressWarnings("unchecked")
	public T connectionListenerClass(java.lang.String value) {
		Object oldValue = this.connectionListenerClass;
		this.connectionListenerClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionListenerClass", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Properties to be injected in class specidied in connection-listener-class
	 */
	@ModelNodeBinding(detypedName = "connection-listener-property")
	public Map connectionListenerProperty() {
		return this.connectionListenerProperty;
	}

	/**
	 * Properties to be injected in class specidied in connection-listener-class
	 */
	@SuppressWarnings("unchecked")
	public T connectionListenerProperty(java.util.Map value) {
		Object oldValue = this.connectionListenerProperty;
		this.connectionListenerProperty = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionListenerProperty", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Properties to be injected in class specidied in connection-listener-class
	 */
	@SuppressWarnings("unchecked")
	public T connectionListenerProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.connectionListenerProperty == null) {
			this.connectionListenerProperty = new java.util.HashMap<>();
		}
		this.connectionListenerProperty.put(key, value);
		return (T) this;
	}

	/**
	 * The JDBC driver connection URL
	 */
	@ModelNodeBinding(detypedName = "connection-url")
	public String connectionUrl() {
		return this.connectionUrl;
	}

	/**
	 * The JDBC driver connection URL
	 */
	@SuppressWarnings("unchecked")
	public T connectionUrl(java.lang.String value) {
		Object oldValue = this.connectionUrl;
		this.connectionUrl = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("connectionUrl", oldValue, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate on data source
	 */
	@ModelNodeBinding(detypedName = "credential-reference")
	public Map credentialReference() {
		return this.credentialReference;
	}

	/**
	 * Credential (from Credential Store) to authenticate on data source
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.util.Map value) {
		Object oldValue = this.credentialReference;
		this.credentialReference = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("credentialReference", oldValue, value);
		return (T) this;
	}

	/**
	 * Credential (from Credential Store) to authenticate on data source
	 */
	@SuppressWarnings("unchecked")
	public T credentialReference(java.lang.String key, java.lang.Object value) {
		if (this.credentialReference == null) {
			this.credentialReference = new java.util.HashMap<>();
		}
		this.credentialReference.put(key, value);
		return (T) this;
	}

	/**
	 * The fully qualified name of the JDBC datasource class
	 */
	@ModelNodeBinding(detypedName = "datasource-class")
	public String datasourceClass() {
		return this.datasourceClass;
	}

	/**
	 * The fully qualified name of the JDBC datasource class
	 */
	@SuppressWarnings("unchecked")
	public T datasourceClass(java.lang.String value) {
		Object oldValue = this.datasourceClass;
		this.datasourceClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("datasourceClass", oldValue, value);
		return (T) this;
	}

	/**
	 * The fully qualified name of the JDBC driver class
	 */
	@ModelNodeBinding(detypedName = "driver-class")
	public String driverClass() {
		return this.driverClass;
	}

	/**
	 * The fully qualified name of the JDBC driver class
	 */
	@SuppressWarnings("unchecked")
	public T driverClass(java.lang.String value) {
		Object oldValue = this.driverClass;
		this.driverClass = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverClass", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the JDBC driver the datasource should use. It is a symbolic name
	 * matching the the name of installed driver. In case the driver is deployed
	 * as jar, the name is the name of deployment unit
	 */
	@ModelNodeBinding(detypedName = "driver-name")
	public String driverName() {
		return this.driverName;
	}

	/**
	 * Defines the JDBC driver the datasource should use. It is a symbolic name
	 * matching the the name of installed driver. In case the driver is deployed
	 * as jar, the name is the name of deployment unit
	 */
	@SuppressWarnings("unchecked")
	public T driverName(java.lang.String value) {
		Object oldValue = this.driverName;
		this.driverName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("driverName", oldValue, value);
		return (T) this;
	}

	/**
	 * Enables Elytron security for handling authentication of connections. The
	 * Elytron authentication-context to be used will be current context if no
	 * context is specified (see authentication-context).
	 */
	@ModelNodeBinding(detypedName = "elytron-enabled")
	public Boolean elytronEnabled() {
		return this.elytronEnabled;
	}

	/**
	 * Enables Elytron security for handling authentication of connections. The
	 * Elytron authentication-context to be used will be current context if no
	 * context is specified (see authentication-context).
	 */
	@SuppressWarnings("unchecked")
	public T elytronEnabled(java.lang.Boolean value) {
		Object oldValue = this.elytronEnabled;
		this.elytronEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("elytronEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines if WildFly/IronJacamar should record enlistment traces
	 */
	@ModelNodeBinding(detypedName = "enlistment-trace")
	public Boolean enlistmentTrace() {
		return this.enlistmentTrace;
	}

	/**
	 * Defines if WildFly/IronJacamar should record enlistment traces
	 */
	@SuppressWarnings("unchecked")
	public T enlistmentTrace(java.lang.Boolean value) {
		Object oldValue = this.enlistmentTrace;
		this.enlistmentTrace = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enlistmentTrace", oldValue, value);
		return (T) this;
	}

	/**
	 * An org.jboss.jca.adapters.jdbc.ExceptionSorter that provides an
	 * isExceptionFatal(SQLException) method to validate if an exception should
	 * broadcast an error
	 */
	@ModelNodeBinding(detypedName = "exception-sorter-class-name")
	public String exceptionSorterClassName() {
		return this.exceptionSorterClassName;
	}

	/**
	 * An org.jboss.jca.adapters.jdbc.ExceptionSorter that provides an
	 * isExceptionFatal(SQLException) method to validate if an exception should
	 * broadcast an error
	 */
	@SuppressWarnings("unchecked")
	public T exceptionSorterClassName(java.lang.String value) {
		Object oldValue = this.exceptionSorterClassName;
		this.exceptionSorterClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exceptionSorterClassName", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The exception sorter properties
	 */
	@ModelNodeBinding(detypedName = "exception-sorter-properties")
	public Map exceptionSorterProperties() {
		return this.exceptionSorterProperties;
	}

	/**
	 * The exception sorter properties
	 */
	@SuppressWarnings("unchecked")
	public T exceptionSorterProperties(java.util.Map value) {
		Object oldValue = this.exceptionSorterProperties;
		this.exceptionSorterProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("exceptionSorterProperties", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The exception sorter properties
	 */
	@SuppressWarnings("unchecked")
	public T exceptionSorterProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.exceptionSorterProperties == null) {
			this.exceptionSorterProperties = new java.util.HashMap<>();
		}
		this.exceptionSorterProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Specifies how the pool should be flush in case of an error.
	 */
	@ModelNodeBinding(detypedName = "flush-strategy")
	public FlushStrategy flushStrategy() {
		return this.flushStrategy;
	}

	/**
	 * Specifies how the pool should be flush in case of an error.
	 */
	@SuppressWarnings("unchecked")
	public T flushStrategy(FlushStrategy value) {
		Object oldValue = this.flushStrategy;
		this.flushStrategy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("flushStrategy", oldValue, value);
		return (T) this;
	}

	/**
	 * The idle-timeout-minutes elements specifies the maximum time, in minutes,
	 * a connection may be idle before being closed. The actual maximum time
	 * depends also on the IdleRemover scan time, which is half of the smallest
	 * idle-timeout-minutes value of any pool. Changing this value can be done
	 * only on disabled datasource, requires a server restart otherwise.
	 */
	@ModelNodeBinding(detypedName = "idle-timeout-minutes")
	public Long idleTimeoutMinutes() {
		return this.idleTimeoutMinutes;
	}

	/**
	 * The idle-timeout-minutes elements specifies the maximum time, in minutes,
	 * a connection may be idle before being closed. The actual maximum time
	 * depends also on the IdleRemover scan time, which is half of the smallest
	 * idle-timeout-minutes value of any pool. Changing this value can be done
	 * only on disabled datasource, requires a server restart otherwise.
	 */
	@SuppressWarnings("unchecked")
	public T idleTimeoutMinutes(java.lang.Long value) {
		Object oldValue = this.idleTimeoutMinutes;
		this.idleTimeoutMinutes = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("idleTimeoutMinutes", oldValue, value);
		return (T) this;
	}

	/**
	 * The initial-pool-size element indicates the initial number of connections
	 * a pool should hold.
	 */
	@ModelNodeBinding(detypedName = "initial-pool-size")
	public Integer initialPoolSize() {
		return this.initialPoolSize;
	}

	/**
	 * The initial-pool-size element indicates the initial number of connections
	 * a pool should hold.
	 */
	@SuppressWarnings("unchecked")
	public T initialPoolSize(java.lang.Integer value) {
		Object oldValue = this.initialPoolSize;
		this.initialPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("initialPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the JNDI name for the datasource
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * Specifies the JNDI name for the datasource
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(java.lang.String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * Enable JTA integration
	 */
	@ModelNodeBinding(detypedName = "jta")
	public Boolean jta() {
		return this.jta;
	}

	/**
	 * Enable JTA integration
	 */
	@SuppressWarnings("unchecked")
	public T jta(java.lang.Boolean value) {
		Object oldValue = this.jta;
		this.jta = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jta", oldValue, value);
		return (T) this;
	}

	/**
	 * The max-pool-size element specifies the maximum number of connections for
	 * a pool. No more connections will be created in each sub-pool
	 */
	@ModelNodeBinding(detypedName = "max-pool-size")
	public Integer maxPoolSize() {
		return this.maxPoolSize;
	}

	/**
	 * The max-pool-size element specifies the maximum number of connections for
	 * a pool. No more connections will be created in each sub-pool
	 */
	@SuppressWarnings("unchecked")
	public T maxPoolSize(java.lang.Integer value) {
		Object oldValue = this.maxPoolSize;
		this.maxPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("maxPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines the ManagedConnectionPool implementation, f.ex.
	 * org.jboss.jca.core
	 * .connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool
	 */
	@ModelNodeBinding(detypedName = "mcp")
	public String mcp() {
		return this.mcp;
	}

	/**
	 * Defines the ManagedConnectionPool implementation, f.ex.
	 * org.jboss.jca.core
	 * .connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool
	 */
	@SuppressWarnings("unchecked")
	public T mcp(java.lang.String value) {
		Object oldValue = this.mcp;
		this.mcp = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("mcp", oldValue, value);
		return (T) this;
	}

	/**
	 * The min-pool-size element specifies the minimum number of connections for
	 * a pool
	 */
	@ModelNodeBinding(detypedName = "min-pool-size")
	public Integer minPoolSize() {
		return this.minPoolSize;
	}

	/**
	 * The min-pool-size element specifies the minimum number of connections for
	 * a pool
	 */
	@SuppressWarnings("unchecked")
	public T minPoolSize(java.lang.Integer value) {
		Object oldValue = this.minPoolSize;
		this.minPoolSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("minPoolSize", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies an SQL statement to execute whenever a connection is added to
	 * the connection pool
	 */
	@ModelNodeBinding(detypedName = "new-connection-sql")
	public String newConnectionSql() {
		return this.newConnectionSql;
	}

	/**
	 * Specifies an SQL statement to execute whenever a connection is added to
	 * the connection pool
	 */
	@SuppressWarnings("unchecked")
	public T newConnectionSql(java.lang.String value) {
		Object oldValue = this.newConnectionSql;
		this.newConnectionSql = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("newConnectionSql", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the password used when creating a new connection
	 */
	@ModelNodeBinding(detypedName = "password")
	public String password() {
		return this.password;
	}

	/**
	 * Specifies the password used when creating a new connection
	 */
	@SuppressWarnings("unchecked")
	public T password(java.lang.String value) {
		Object oldValue = this.password;
		this.password = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("password", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines if pool use should be fair
	 */
	@ModelNodeBinding(detypedName = "pool-fair")
	public Boolean poolFair() {
		return this.poolFair;
	}

	/**
	 * Defines if pool use should be fair
	 */
	@SuppressWarnings("unchecked")
	public T poolFair(java.lang.Boolean value) {
		Object oldValue = this.poolFair;
		this.poolFair = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("poolFair", oldValue, value);
		return (T) this;
	}

	/**
	 * Should the pool be prefilled. Changing this value can be done only on
	 * disabled datasource, requires a server restart otherwise.
	 */
	@ModelNodeBinding(detypedName = "pool-prefill")
	public Boolean poolPrefill() {
		return this.poolPrefill;
	}

	/**
	 * Should the pool be prefilled. Changing this value can be done only on
	 * disabled datasource, requires a server restart otherwise.
	 */
	@SuppressWarnings("unchecked")
	public T poolPrefill(java.lang.Boolean value) {
		Object oldValue = this.poolPrefill;
		this.poolPrefill = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("poolPrefill", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies if the min-pool-size should be considered strictly
	 */
	@ModelNodeBinding(detypedName = "pool-use-strict-min")
	public Boolean poolUseStrictMin() {
		return this.poolUseStrictMin;
	}

	/**
	 * Specifies if the min-pool-size should be considered strictly
	 */
	@SuppressWarnings("unchecked")
	public T poolUseStrictMin(java.lang.Boolean value) {
		Object oldValue = this.poolUseStrictMin;
		this.poolUseStrictMin = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("poolUseStrictMin", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of prepared statements per connection in an LRU cache
	 */
	@ModelNodeBinding(detypedName = "prepared-statements-cache-size")
	public Long preparedStatementsCacheSize() {
		return this.preparedStatementsCacheSize;
	}

	/**
	 * The number of prepared statements per connection in an LRU cache
	 */
	@SuppressWarnings("unchecked")
	public T preparedStatementsCacheSize(java.lang.Long value) {
		Object oldValue = this.preparedStatementsCacheSize;
		this.preparedStatementsCacheSize = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("preparedStatementsCacheSize",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Any configured query timeout in seconds. If not provided no timeout will
	 * be set
	 */
	@ModelNodeBinding(detypedName = "query-timeout")
	public Long queryTimeout() {
		return this.queryTimeout;
	}

	/**
	 * Any configured query timeout in seconds. If not provided no timeout will
	 * be set
	 */
	@SuppressWarnings("unchecked")
	public T queryTimeout(java.lang.Long value) {
		Object oldValue = this.queryTimeout;
		this.queryTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("queryTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * The fully qualified class name of the reauthentication plugin
	 * implementation
	 */
	@ModelNodeBinding(detypedName = "reauth-plugin-class-name")
	public String reauthPluginClassName() {
		return this.reauthPluginClassName;
	}

	/**
	 * The fully qualified class name of the reauthentication plugin
	 * implementation
	 */
	@SuppressWarnings("unchecked")
	public T reauthPluginClassName(java.lang.String value) {
		Object oldValue = this.reauthPluginClassName;
		this.reauthPluginClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reauthPluginClassName", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The properties for the reauthentication plugin
	 */
	@ModelNodeBinding(detypedName = "reauth-plugin-properties")
	public Map reauthPluginProperties() {
		return this.reauthPluginProperties;
	}

	/**
	 * The properties for the reauthentication plugin
	 */
	@SuppressWarnings("unchecked")
	public T reauthPluginProperties(java.util.Map value) {
		Object oldValue = this.reauthPluginProperties;
		this.reauthPluginProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("reauthPluginProperties", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The properties for the reauthentication plugin
	 */
	@SuppressWarnings("unchecked")
	public T reauthPluginProperty(java.lang.String key, java.lang.Object value) {
		if (this.reauthPluginProperties == null) {
			this.reauthPluginProperties = new java.util.HashMap<>();
		}
		this.reauthPluginProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Specifies the PicketBox security domain which defines the PicketBox
	 * javax.security.auth.Subject that are used to distinguish connections in
	 * the pool
	 */
	@ModelNodeBinding(detypedName = "security-domain")
	public String securityDomain() {
		return this.securityDomain;
	}

	/**
	 * Specifies the PicketBox security domain which defines the PicketBox
	 * javax.security.auth.Subject that are used to distinguish connections in
	 * the pool
	 */
	@SuppressWarnings("unchecked")
	public T securityDomain(java.lang.String value) {
		Object oldValue = this.securityDomain;
		this.securityDomain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("securityDomain", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to set the query timeout based on the time remaining until
	 * transaction timeout. Any configured query timeout will be used if there
	 * is no transaction
	 */
	@ModelNodeBinding(detypedName = "set-tx-query-timeout")
	public Boolean setTxQueryTimeout() {
		return this.setTxQueryTimeout;
	}

	/**
	 * Whether to set the query timeout based on the time remaining until
	 * transaction timeout. Any configured query timeout will be used if there
	 * is no transaction
	 */
	@SuppressWarnings("unchecked")
	public T setTxQueryTimeout(java.lang.Boolean value) {
		Object oldValue = this.setTxQueryTimeout;
		this.setTxQueryTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("setTxQueryTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to share prepared statements, i.e. whether asking for same
	 * statement twice without closing uses the same underlying prepared
	 * statement
	 */
	@ModelNodeBinding(detypedName = "share-prepared-statements")
	public Boolean sharePreparedStatements() {
		return this.sharePreparedStatements;
	}

	/**
	 * Whether to share prepared statements, i.e. whether asking for same
	 * statement twice without closing uses the same underlying prepared
	 * statement
	 */
	@SuppressWarnings("unchecked")
	public T sharePreparedStatements(java.lang.Boolean value) {
		Object oldValue = this.sharePreparedStatements;
		this.sharePreparedStatements = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("sharePreparedStatements", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Enable spying of SQL statements
	 */
	@ModelNodeBinding(detypedName = "spy")
	public Boolean spy() {
		return this.spy;
	}

	/**
	 * Enable spying of SQL statements
	 */
	@SuppressWarnings("unchecked")
	public T spy(java.lang.Boolean value) {
		Object oldValue = this.spy;
		this.spy = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("spy", oldValue, value);
		return (T) this;
	}

	/**
	 * An org.jboss.jca.adapters.jdbc.StaleConnectionChecker that provides an
	 * isStaleConnection(SQLException) method which if it returns true will wrap
	 * the exception in an org.jboss.jca.adapters.jdbc.StaleConnectionException
	 */
	@ModelNodeBinding(detypedName = "stale-connection-checker-class-name")
	public String staleConnectionCheckerClassName() {
		return this.staleConnectionCheckerClassName;
	}

	/**
	 * An org.jboss.jca.adapters.jdbc.StaleConnectionChecker that provides an
	 * isStaleConnection(SQLException) method which if it returns true will wrap
	 * the exception in an org.jboss.jca.adapters.jdbc.StaleConnectionException
	 */
	@SuppressWarnings("unchecked")
	public T staleConnectionCheckerClassName(java.lang.String value) {
		Object oldValue = this.staleConnectionCheckerClassName;
		this.staleConnectionCheckerClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("staleConnectionCheckerClassName",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The stale connection checker properties
	 */
	@ModelNodeBinding(detypedName = "stale-connection-checker-properties")
	public Map staleConnectionCheckerProperties() {
		return this.staleConnectionCheckerProperties;
	}

	/**
	 * The stale connection checker properties
	 */
	@SuppressWarnings("unchecked")
	public T staleConnectionCheckerProperties(java.util.Map value) {
		Object oldValue = this.staleConnectionCheckerProperties;
		this.staleConnectionCheckerProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("staleConnectionCheckerProperties",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The stale connection checker properties
	 */
	@SuppressWarnings("unchecked")
	public T staleConnectionCheckerProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.staleConnectionCheckerProperties == null) {
			this.staleConnectionCheckerProperties = new java.util.HashMap<>();
		}
		this.staleConnectionCheckerProperties.put(key, value);
		return (T) this;
	}

	/**
	 * Define whether runtime statistics are enabled or not.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Define whether runtime statistics are enabled or not.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to check for unclosed statements when a connection is returned to
	 * the pool, result sets are closed, a statement is closed or return to the
	 * prepared statement cache. Valid values are: "false" - do not track
	 * statements, "true" - track statements and result sets and warn when they
	 * are not closed, "nowarn" - track statements but do not warn about them
	 * being unclosed
	 */
	@ModelNodeBinding(detypedName = "track-statements")
	public String trackStatements() {
		return this.trackStatements;
	}

	/**
	 * Whether to check for unclosed statements when a connection is returned to
	 * the pool, result sets are closed, a statement is closed or return to the
	 * prepared statement cache. Valid values are: "false" - do not track
	 * statements, "true" - track statements and result sets and warn when they
	 * are not closed, "nowarn" - track statements but do not warn about them
	 * being unclosed
	 */
	@SuppressWarnings("unchecked")
	public T trackStatements(java.lang.String value) {
		Object oldValue = this.trackStatements;
		this.trackStatements = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("trackStatements", oldValue, value);
		return (T) this;
	}

	/**
	 * Defines if IronJacamar should track connection handles across transaction
	 * boundaries
	 */
	@ModelNodeBinding(detypedName = "tracking")
	public Boolean tracking() {
		return this.tracking;
	}

	/**
	 * Defines if IronJacamar should track connection handles across transaction
	 * boundaries
	 */
	@SuppressWarnings("unchecked")
	public T tracking(java.lang.Boolean value) {
		Object oldValue = this.tracking;
		this.tracking = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("tracking", oldValue, value);
		return (T) this;
	}

	/**
	 * Set the java.sql.Connection transaction isolation level. Valid values
	 * are: TRANSACTION_READ_UNCOMMITTED, TRANSACTION_READ_COMMITTED,
	 * TRANSACTION_REPEATABLE_READ, TRANSACTION_SERIALIZABLE and
	 * TRANSACTION_NONE. Different values are used to set customLevel using
	 * TransactionIsolation#customLevel
	 */
	@ModelNodeBinding(detypedName = "transaction-isolation")
	public String transactionIsolation() {
		return this.transactionIsolation;
	}

	/**
	 * Set the java.sql.Connection transaction isolation level. Valid values
	 * are: TRANSACTION_READ_UNCOMMITTED, TRANSACTION_READ_COMMITTED,
	 * TRANSACTION_REPEATABLE_READ, TRANSACTION_SERIALIZABLE and
	 * TRANSACTION_NONE. Different values are used to set customLevel using
	 * TransactionIsolation#customLevel
	 */
	@SuppressWarnings("unchecked")
	public T transactionIsolation(java.lang.String value) {
		Object oldValue = this.transactionIsolation;
		this.transactionIsolation = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("transactionIsolation", oldValue, value);
		return (T) this;
	}

	/**
	 * Specifies the delimiter for URLs in connection-url for HA datasources
	 */
	@ModelNodeBinding(detypedName = "url-delimiter")
	public String urlDelimiter() {
		return this.urlDelimiter;
	}

	/**
	 * Specifies the delimiter for URLs in connection-url for HA datasources
	 */
	@SuppressWarnings("unchecked")
	public T urlDelimiter(java.lang.String value) {
		Object oldValue = this.urlDelimiter;
		this.urlDelimiter = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("urlDelimiter", oldValue, value);
		return (T) this;
	}

	/**
	 * A class that implements org.jboss.jca.adapters.jdbc.URLSelectorStrategy
	 */
	@ModelNodeBinding(detypedName = "url-selector-strategy-class-name")
	public String urlSelectorStrategyClassName() {
		return this.urlSelectorStrategyClassName;
	}

	/**
	 * A class that implements org.jboss.jca.adapters.jdbc.URLSelectorStrategy
	 */
	@SuppressWarnings("unchecked")
	public T urlSelectorStrategyClassName(java.lang.String value) {
		Object oldValue = this.urlSelectorStrategyClassName;
		this.urlSelectorStrategyClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("urlSelectorStrategyClassName",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Enable the use of a cached connection manager
	 */
	@ModelNodeBinding(detypedName = "use-ccm")
	public Boolean useCcm() {
		return this.useCcm;
	}

	/**
	 * Enable the use of a cached connection manager
	 */
	@SuppressWarnings("unchecked")
	public T useCcm(java.lang.Boolean value) {
		Object oldValue = this.useCcm;
		this.useCcm = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useCcm", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether to fail a connection allocation on the first try if it is invalid
	 * (true) or keep trying until the pool is exhausted of all potential
	 * connections (false)
	 */
	@ModelNodeBinding(detypedName = "use-fast-fail")
	public Boolean useFastFail() {
		return this.useFastFail;
	}

	/**
	 * Whether to fail a connection allocation on the first try if it is invalid
	 * (true) or keep trying until the pool is exhausted of all potential
	 * connections (false)
	 */
	@SuppressWarnings("unchecked")
	public T useFastFail(java.lang.Boolean value) {
		Object oldValue = this.useFastFail;
		this.useFastFail = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useFastFail", oldValue, value);
		return (T) this;
	}

	/**
	 * Setting this to false will bind the datasource into global JNDI
	 */
	@ModelNodeBinding(detypedName = "use-java-context")
	public Boolean useJavaContext() {
		return this.useJavaContext;
	}

	/**
	 * Setting this to false will bind the datasource into global JNDI
	 */
	@SuppressWarnings("unchecked")
	public T useJavaContext(java.lang.Boolean value) {
		Object oldValue = this.useJavaContext;
		this.useJavaContext = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useJavaContext", oldValue, value);
		return (T) this;
	}

	/**
	 * Any configured timeout for internal locks on the resource adapter objects
	 * in seconds
	 */
	@ModelNodeBinding(detypedName = "use-try-lock")
	public Long useTryLock() {
		return this.useTryLock;
	}

	/**
	 * Any configured timeout for internal locks on the resource adapter objects
	 * in seconds
	 */
	@SuppressWarnings("unchecked")
	public T useTryLock(java.lang.Long value) {
		Object oldValue = this.useTryLock;
		this.useTryLock = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useTryLock", oldValue, value);
		return (T) this;
	}

	/**
	 * Specify the user name used when creating a new connection
	 */
	@ModelNodeBinding(detypedName = "user-name")
	public String userName() {
		return this.userName;
	}

	/**
	 * Specify the user name used when creating a new connection
	 */
	@SuppressWarnings("unchecked")
	public T userName(java.lang.String value) {
		Object oldValue = this.userName;
		this.userName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("userName", oldValue, value);
		return (T) this;
	}

	/**
	 * An org.jboss.jca.adapters.jdbc.ValidConnectionChecker that provides an
	 * isValidConnection(Connection) method to validate a connection. If an
	 * exception is returned that means the connection is invalid. This
	 * overrides the check-valid-connection-sql element
	 */
	@ModelNodeBinding(detypedName = "valid-connection-checker-class-name")
	public String validConnectionCheckerClassName() {
		return this.validConnectionCheckerClassName;
	}

	/**
	 * An org.jboss.jca.adapters.jdbc.ValidConnectionChecker that provides an
	 * isValidConnection(Connection) method to validate a connection. If an
	 * exception is returned that means the connection is invalid. This
	 * overrides the check-valid-connection-sql element
	 */
	@SuppressWarnings("unchecked")
	public T validConnectionCheckerClassName(java.lang.String value) {
		Object oldValue = this.validConnectionCheckerClassName;
		this.validConnectionCheckerClassName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("validConnectionCheckerClassName",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The valid connection checker properties
	 */
	@ModelNodeBinding(detypedName = "valid-connection-checker-properties")
	public Map validConnectionCheckerProperties() {
		return this.validConnectionCheckerProperties;
	}

	/**
	 * The valid connection checker properties
	 */
	@SuppressWarnings("unchecked")
	public T validConnectionCheckerProperties(java.util.Map value) {
		Object oldValue = this.validConnectionCheckerProperties;
		this.validConnectionCheckerProperties = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("validConnectionCheckerProperties",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The valid connection checker properties
	 */
	@SuppressWarnings("unchecked")
	public T validConnectionCheckerProperty(java.lang.String key,
			java.lang.Object value) {
		if (this.validConnectionCheckerProperties == null) {
			this.validConnectionCheckerProperties = new java.util.HashMap<>();
		}
		this.validConnectionCheckerProperties.put(key, value);
		return (T) this;
	}

	/**
	 * The validate-on-match element specifies if connection validation should
	 * be done when a connection factory attempts to match a managed connection.
	 * This is typically exclusive to the use of background validation
	 */
	@ModelNodeBinding(detypedName = "validate-on-match")
	public Boolean validateOnMatch() {
		return this.validateOnMatch;
	}

	/**
	 * The validate-on-match element specifies if connection validation should
	 * be done when a connection factory attempts to match a managed connection.
	 * This is typically exclusive to the use of background validation
	 */
	@SuppressWarnings("unchecked")
	public T validateOnMatch(java.lang.Boolean value) {
		Object oldValue = this.validateOnMatch;
		this.validateOnMatch = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("validateOnMatch", oldValue, value);
		return (T) this;
	}
}