package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.CommitMarkableResourceConsumer;
import org.wildfly.swarm.config.transactions.CommitMarkableResourceSupplier;
import org.wildfly.swarm.config.transactions.CommitMarkableResource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;
import org.wildfly.swarm.config.transactions.LogStore;
import org.wildfly.swarm.config.transactions.LogStoreConsumer;
import org.wildfly.swarm.config.transactions.LogStoreSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;

/**
 * The configuration of the transaction subsystem.
 */
@Address("/subsystem=transactions")
@ResourceType("subsystem")
@Implicit
public class Transactions<T extends Transactions<T>>
		implements
			org.wildfly.swarm.config.runtime.Keyed {

	private String key;
	private PropertyChangeSupport pcs;
	private TransactionsResources subresources = new TransactionsResources();
	@AttributeDocumentation("The average time of transaction commit in nanoseconds, measured from the moment the client calls commit until the transaction manager determines that the commit attempt was successful.")
	private Long averageCommitTime;
	@AttributeDocumentation("The default timeout for a transaction managed by the transaction manager.")
	private Integer defaultTimeout;
	@AttributeDocumentation("Whether transaction statistics should be gathered.")
	private Boolean enableStatistics;
	@AttributeDocumentation("Whether the transaction status manager (TSM) service, needed for out of process recovery, should be provided or not.")
	private Boolean enableTsmStatus;
	@AttributeDocumentation("Whether AsyncIO should be enabled for the journal store.")
	private Boolean hornetqStoreEnableAsyncIo;
	@AttributeDocumentation("Configure if jdbc action store should drop tables.")
	private Boolean jdbcActionStoreDropTable;
	@AttributeDocumentation("Optional prefix for table used to write transaction logs in configured jdbc action store.")
	private String jdbcActionStoreTablePrefix;
	@AttributeDocumentation("Configure if jdbc communication store should drop tables.")
	private Boolean jdbcCommunicationStoreDropTable;
	@AttributeDocumentation("Optional prefix for table used to write transaction logs in configured jdbc communication store.")
	private String jdbcCommunicationStoreTablePrefix;
	@AttributeDocumentation("Configure if jdbc state store should drop tables.")
	private Boolean jdbcStateStoreDropTable;
	@AttributeDocumentation("Optional prefix for table used to write transaction logs in configured jdbc state store.")
	private String jdbcStateStoreTablePrefix;
	@AttributeDocumentation("Jndi name of non-XA datasource used. Datasource sghould be define in datasources subsystem. For this would work the non-XA datasource has to be marked as jta=\"false\".")
	private String jdbcStoreDatasource;
	@AttributeDocumentation("Whether AsyncIO should be enabled for the journal store. For this settings being active journal natives libraries needs to be available.")
	private Boolean journalStoreEnableAsyncIo;
	@AttributeDocumentation("If true this enables the Java Transaction Service. Use of the JTS needs configuration in IIOP OpenJDK where Transactions parameter needs to be set to full.")
	private Boolean jts;
	@AttributeDocumentation("Used to set the node identifier on the core environment. Each Xid that Transaction Manager creates will have this identifier encoded within it and ensures Transaction Manager will only recover branches which match the specified identifier. It is imperative that this identifier is unique between Application Server instances which share either an object store or access common resource managers.")
	private String nodeIdentifier;
	@AttributeDocumentation("The number of aborted (i.e. rolledback) transactions.")
	private Long numberOfAbortedTransactions;
	@AttributeDocumentation("The number of transactions that have been rolled back by application request. This includes those that timeout, since the timeout behavior is considered an attribute of the application configuration.")
	private Long numberOfApplicationRollbacks;
	@AttributeDocumentation("The number of committed transactions.")
	private Long numberOfCommittedTransactions;
	@AttributeDocumentation("The number of transactions which have terminated with heuristic outcomes.")
	private Long numberOfHeuristics;
	@AttributeDocumentation("The number of transactions that have begun but not yet terminated.")
	private Long numberOfInflightTransactions;
	@AttributeDocumentation("The total number of nested (sub) transactions created.")
	private Long numberOfNestedTransactions;
	@AttributeDocumentation("The number of transactions that rolled back due to resource (participant) failure.")
	private Long numberOfResourceRollbacks;
	@AttributeDocumentation("The number of transactions that have been rolled back due to internal system errors.")
	private Long numberOfSystemRollbacks;
	@AttributeDocumentation("The number of transactions that have rolled back due to timeout.")
	private Long numberOfTimedOutTransactions;
	@AttributeDocumentation("The total number of transactions (top-level and nested) created")
	private Long numberOfTransactions;
	@AttributeDocumentation("Denotes a relative or absolute filesystem path denoting where the transaction manager object store should store data. By default the value is treated as relative to the path denoted by the \"relative-to\" attribute. This settings is valid when default or journal store is used. It's not used when jdbc journal store is used.")
	private String objectStorePath;
	@AttributeDocumentation("References a global path configuration in the domain model, defaulting to the Application Server data directory (jboss.server.data.dir). The value of the \"Object store path\" attribute will treated as relative to this path. Undefine this attribute to disable the default behavior and force the value of the \"Object store path\" attribute to be treated as an absolute path.")
	private String objectStoreRelativeTo;
	@AttributeDocumentation("The name of the socket binding configuration to use if the transaction manager should use a socket-based process id. Will be 'undefined' if 'process-id-uuid' is 'true'; otherwise must be set.")
	private String processIdSocketBinding;
	@AttributeDocumentation("The maximum number of ports to search for an open port if the transaction manager should use a socket-based process id. If the port specified by the socket binding referenced in 'process-id-socket-binding' is occupied, the next higher port will be tried until an open port is found or the number of ports specified by this attribute have been tried. Will be 'undefined' if 'process-id-uuid' is 'true'.")
	private Integer processIdSocketMaxPorts;
	@AttributeDocumentation("Indicates whether the transaction manager should use a UUID based process id.")
	private Boolean processIdUuid;
	@AttributeDocumentation("Used to specify if the recovery system should listen on a network socket or not.")
	private Boolean recoveryListener;
	@AttributeDocumentation("Used to reference the correct socket binding to use for the recovery environment.")
	private String socketBinding;
	@AttributeDocumentation("Whether transaction statistics should be gathered.")
	private Boolean statisticsEnabled;
	@AttributeDocumentation("Used to reference the correct socket binding to use for the transaction status manager.")
	private String statusSocketBinding;
	@AttributeDocumentation("Use the journal store for writing transaction logs. Set to true to enable and to false to use the default log store type. The default log store is normally one file system file per transaction log.It's alternative to jdbc based store.")
	private Boolean useHornetqStore;
	@AttributeDocumentation("Use the jdbc store for writing transaction logs. Set to true to enable and to false to use the default log store type. The default log store is normally one file file per transaction log. It's alternative to journal based store.")
	private Boolean useJdbcStore;
	@AttributeDocumentation("Use the journal store for writing transaction logs. Set to true to enable and to false to use the default log store type. The default log store creates normally one file system file per transaction log. The journal one consists from one file for all the transactions. It's alternative to jdbc based store.")
	private Boolean useJournalStore;

	public Transactions() {
		super();
		this.key = "transactions";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(
			java.beans.PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public TransactionsResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all CommitMarkableResource objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of CommitMarkableResource objects.
	 */
	@SuppressWarnings("unchecked")
	public T commitMarkableResources(
			java.util.List<CommitMarkableResource> value) {
		this.subresources.commitMarkableResources = value;
		return (T) this;
	}

	/**
	 * Add the CommitMarkableResource object to the list of subresources
	 * 
	 * @param value
	 *            The CommitMarkableResource to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T commitMarkableResource(CommitMarkableResource value) {
		this.subresources.commitMarkableResources.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a CommitMarkableResource object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CommitMarkableResource resource
	 * @param config
	 *            The CommitMarkableResourceConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T commitMarkableResource(java.lang.String childKey,
			CommitMarkableResourceConsumer consumer) {
		CommitMarkableResource<? extends CommitMarkableResource> child = new CommitMarkableResource<>(
				childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		commitMarkableResource(child);
		return (T) this;
	}

	/**
	 * Create and configure a CommitMarkableResource object to the list of
	 * subresources
	 * 
	 * @param key
	 *            The key for the CommitMarkableResource resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T commitMarkableResource(java.lang.String childKey) {
		commitMarkableResource(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied CommitMarkableResource object to the list of
	 * subresources
	 */
	@SuppressWarnings("unchecked")
	public T commitMarkableResource(CommitMarkableResourceSupplier supplier) {
		commitMarkableResource(supplier.get());
		return (T) this;
	}

	/**
	 * Representation of the transaction logging storage mechanism.
	 */
	@SuppressWarnings("unchecked")
	public T logStore(LogStore value) {
		this.subresources.logStore = value;
		return (T) this;
	}

	/**
	 * Representation of the transaction logging storage mechanism.
	 */
	@SuppressWarnings("unchecked")
	public T logStore(LogStoreConsumer consumer) {
		LogStore<? extends LogStore> child = new LogStore<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.logStore = child;
		return (T) this;
	}

	/**
	 * Representation of the transaction logging storage mechanism.
	 */
	@SuppressWarnings("unchecked")
	public T logStore() {
		LogStore<? extends LogStore> child = new LogStore<>();
		this.subresources.logStore = child;
		return (T) this;
	}

	/**
	 * Representation of the transaction logging storage mechanism.
	 */
	@SuppressWarnings("unchecked")
	public T logStore(LogStoreSupplier supplier) {
		this.subresources.logStore = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Transactions
	 */
	public static class TransactionsResources {
		/**
		 * a CMR resource (i.e. a local resource that can reliably participate
		 * in an XA transaction)
		 */
		@ResourceDocumentation("a CMR resource (i.e. a local resource that can reliably participate in an XA transaction)")
		@SubresourceInfo("commitMarkableResource")
		private List<CommitMarkableResource> commitMarkableResources = new java.util.ArrayList<>();
		@SingletonResource
		@ResourceDocumentation("Representation of the transaction logging storage mechanism.")
		private LogStore logStore;

		/**
		 * Get the list of CommitMarkableResource resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<CommitMarkableResource> commitMarkableResources() {
			return this.commitMarkableResources;
		}

		public CommitMarkableResource commitMarkableResource(
				java.lang.String key) {
			return this.commitMarkableResources.stream()
					.filter(e -> e.getKey().equals(key)).findFirst()
					.orElse(null);
		}
		/**
		 * Representation of the transaction logging storage mechanism.
		 */
		@Subresource
		public LogStore logStore() {
			return this.logStore;
		}
	}

	/**
	 * The average time of transaction commit in nanoseconds, measured from the
	 * moment the client calls commit until the transaction manager determines
	 * that the commit attempt was successful.
	 */
	@ModelNodeBinding(detypedName = "average-commit-time")
	public Long averageCommitTime() {
		return this.averageCommitTime;
	}

	/**
	 * The average time of transaction commit in nanoseconds, measured from the
	 * moment the client calls commit until the transaction manager determines
	 * that the commit attempt was successful.
	 */
	@SuppressWarnings("unchecked")
	public T averageCommitTime(java.lang.Long value) {
		Object oldValue = this.averageCommitTime;
		this.averageCommitTime = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("averageCommitTime", oldValue, value);
		return (T) this;
	}

	/**
	 * The default timeout for a transaction managed by the transaction manager.
	 */
	@ModelNodeBinding(detypedName = "default-timeout")
	public Integer defaultTimeout() {
		return this.defaultTimeout;
	}

	/**
	 * The default timeout for a transaction managed by the transaction manager.
	 */
	@SuppressWarnings("unchecked")
	public T defaultTimeout(java.lang.Integer value) {
		Object oldValue = this.defaultTimeout;
		this.defaultTimeout = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("defaultTimeout", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether transaction statistics should be gathered.
	 */
	@ModelNodeBinding(detypedName = "enable-statistics")
	public Boolean enableStatistics() {
		return this.enableStatistics;
	}

	/**
	 * Whether transaction statistics should be gathered.
	 */
	@SuppressWarnings("unchecked")
	public T enableStatistics(java.lang.Boolean value) {
		Object oldValue = this.enableStatistics;
		this.enableStatistics = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableStatistics", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether the transaction status manager (TSM) service, needed for out of
	 * process recovery, should be provided or not.
	 */
	@ModelNodeBinding(detypedName = "enable-tsm-status")
	public Boolean enableTsmStatus() {
		return this.enableTsmStatus;
	}

	/**
	 * Whether the transaction status manager (TSM) service, needed for out of
	 * process recovery, should be provided or not.
	 */
	@SuppressWarnings("unchecked")
	public T enableTsmStatus(java.lang.Boolean value) {
		Object oldValue = this.enableTsmStatus;
		this.enableTsmStatus = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("enableTsmStatus", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether AsyncIO should be enabled for the journal store.
	 */
	@ModelNodeBinding(detypedName = "hornetq-store-enable-async-io")
	public Boolean hornetqStoreEnableAsyncIo() {
		return this.hornetqStoreEnableAsyncIo;
	}

	/**
	 * Whether AsyncIO should be enabled for the journal store.
	 */
	@SuppressWarnings("unchecked")
	public T hornetqStoreEnableAsyncIo(java.lang.Boolean value) {
		Object oldValue = this.hornetqStoreEnableAsyncIo;
		this.hornetqStoreEnableAsyncIo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("hornetqStoreEnableAsyncIo", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Configure if jdbc action store should drop tables.
	 */
	@ModelNodeBinding(detypedName = "jdbc-action-store-drop-table")
	public Boolean jdbcActionStoreDropTable() {
		return this.jdbcActionStoreDropTable;
	}

	/**
	 * Configure if jdbc action store should drop tables.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcActionStoreDropTable(java.lang.Boolean value) {
		Object oldValue = this.jdbcActionStoreDropTable;
		this.jdbcActionStoreDropTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcActionStoreDropTable", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Optional prefix for table used to write transaction logs in configured
	 * jdbc action store.
	 */
	@ModelNodeBinding(detypedName = "jdbc-action-store-table-prefix")
	public String jdbcActionStoreTablePrefix() {
		return this.jdbcActionStoreTablePrefix;
	}

	/**
	 * Optional prefix for table used to write transaction logs in configured
	 * jdbc action store.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcActionStoreTablePrefix(java.lang.String value) {
		Object oldValue = this.jdbcActionStoreTablePrefix;
		this.jdbcActionStoreTablePrefix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcActionStoreTablePrefix", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Configure if jdbc communication store should drop tables.
	 */
	@ModelNodeBinding(detypedName = "jdbc-communication-store-drop-table")
	public Boolean jdbcCommunicationStoreDropTable() {
		return this.jdbcCommunicationStoreDropTable;
	}

	/**
	 * Configure if jdbc communication store should drop tables.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcCommunicationStoreDropTable(java.lang.Boolean value) {
		Object oldValue = this.jdbcCommunicationStoreDropTable;
		this.jdbcCommunicationStoreDropTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcCommunicationStoreDropTable",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Optional prefix for table used to write transaction logs in configured
	 * jdbc communication store.
	 */
	@ModelNodeBinding(detypedName = "jdbc-communication-store-table-prefix")
	public String jdbcCommunicationStoreTablePrefix() {
		return this.jdbcCommunicationStoreTablePrefix;
	}

	/**
	 * Optional prefix for table used to write transaction logs in configured
	 * jdbc communication store.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcCommunicationStoreTablePrefix(java.lang.String value) {
		Object oldValue = this.jdbcCommunicationStoreTablePrefix;
		this.jdbcCommunicationStoreTablePrefix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcCommunicationStoreTablePrefix",
					oldValue, value);
		return (T) this;
	}

	/**
	 * Configure if jdbc state store should drop tables.
	 */
	@ModelNodeBinding(detypedName = "jdbc-state-store-drop-table")
	public Boolean jdbcStateStoreDropTable() {
		return this.jdbcStateStoreDropTable;
	}

	/**
	 * Configure if jdbc state store should drop tables.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcStateStoreDropTable(java.lang.Boolean value) {
		Object oldValue = this.jdbcStateStoreDropTable;
		this.jdbcStateStoreDropTable = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcStateStoreDropTable", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Optional prefix for table used to write transaction logs in configured
	 * jdbc state store.
	 */
	@ModelNodeBinding(detypedName = "jdbc-state-store-table-prefix")
	public String jdbcStateStoreTablePrefix() {
		return this.jdbcStateStoreTablePrefix;
	}

	/**
	 * Optional prefix for table used to write transaction logs in configured
	 * jdbc state store.
	 */
	@SuppressWarnings("unchecked")
	public T jdbcStateStoreTablePrefix(java.lang.String value) {
		Object oldValue = this.jdbcStateStoreTablePrefix;
		this.jdbcStateStoreTablePrefix = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcStateStoreTablePrefix", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Jndi name of non-XA datasource used. Datasource sghould be define in
	 * datasources subsystem. For this would work the non-XA datasource has to
	 * be marked as jta="false".
	 */
	@ModelNodeBinding(detypedName = "jdbc-store-datasource")
	public String jdbcStoreDatasource() {
		return this.jdbcStoreDatasource;
	}

	/**
	 * Jndi name of non-XA datasource used. Datasource sghould be define in
	 * datasources subsystem. For this would work the non-XA datasource has to
	 * be marked as jta="false".
	 */
	@SuppressWarnings("unchecked")
	public T jdbcStoreDatasource(java.lang.String value) {
		Object oldValue = this.jdbcStoreDatasource;
		this.jdbcStoreDatasource = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jdbcStoreDatasource", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether AsyncIO should be enabled for the journal store. For this
	 * settings being active journal natives libraries needs to be available.
	 */
	@ModelNodeBinding(detypedName = "journal-store-enable-async-io")
	public Boolean journalStoreEnableAsyncIo() {
		return this.journalStoreEnableAsyncIo;
	}

	/**
	 * Whether AsyncIO should be enabled for the journal store. For this
	 * settings being active journal natives libraries needs to be available.
	 */
	@SuppressWarnings("unchecked")
	public T journalStoreEnableAsyncIo(java.lang.Boolean value) {
		Object oldValue = this.journalStoreEnableAsyncIo;
		this.journalStoreEnableAsyncIo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("journalStoreEnableAsyncIo", oldValue,
					value);
		return (T) this;
	}

	/**
	 * If true this enables the Java Transaction Service. Use of the JTS needs
	 * configuration in IIOP OpenJDK where Transactions parameter needs to be
	 * set to full.
	 */
	@ModelNodeBinding(detypedName = "jts")
	public Boolean jts() {
		return this.jts;
	}

	/**
	 * If true this enables the Java Transaction Service. Use of the JTS needs
	 * configuration in IIOP OpenJDK where Transactions parameter needs to be
	 * set to full.
	 */
	@SuppressWarnings("unchecked")
	public T jts(java.lang.Boolean value) {
		Object oldValue = this.jts;
		this.jts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jts", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to set the node identifier on the core environment. Each Xid that
	 * Transaction Manager creates will have this identifier encoded within it
	 * and ensures Transaction Manager will only recover branches which match
	 * the specified identifier. It is imperative that this identifier is unique
	 * between Application Server instances which share either an object store
	 * or access common resource managers.
	 */
	@ModelNodeBinding(detypedName = "node-identifier")
	public String nodeIdentifier() {
		return this.nodeIdentifier;
	}

	/**
	 * Used to set the node identifier on the core environment. Each Xid that
	 * Transaction Manager creates will have this identifier encoded within it
	 * and ensures Transaction Manager will only recover branches which match
	 * the specified identifier. It is imperative that this identifier is unique
	 * between Application Server instances which share either an object store
	 * or access common resource managers.
	 */
	@SuppressWarnings("unchecked")
	public T nodeIdentifier(java.lang.String value) {
		Object oldValue = this.nodeIdentifier;
		this.nodeIdentifier = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("nodeIdentifier", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of aborted (i.e. rolledback) transactions.
	 */
	@ModelNodeBinding(detypedName = "number-of-aborted-transactions")
	public Long numberOfAbortedTransactions() {
		return this.numberOfAbortedTransactions;
	}

	/**
	 * The number of aborted (i.e. rolledback) transactions.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfAbortedTransactions(java.lang.Long value) {
		Object oldValue = this.numberOfAbortedTransactions;
		this.numberOfAbortedTransactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfAbortedTransactions",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The number of transactions that have been rolled back by application
	 * request. This includes those that timeout, since the timeout behavior is
	 * considered an attribute of the application configuration.
	 */
	@ModelNodeBinding(detypedName = "number-of-application-rollbacks")
	public Long numberOfApplicationRollbacks() {
		return this.numberOfApplicationRollbacks;
	}

	/**
	 * The number of transactions that have been rolled back by application
	 * request. This includes those that timeout, since the timeout behavior is
	 * considered an attribute of the application configuration.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfApplicationRollbacks(java.lang.Long value) {
		Object oldValue = this.numberOfApplicationRollbacks;
		this.numberOfApplicationRollbacks = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfApplicationRollbacks",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The number of committed transactions.
	 */
	@ModelNodeBinding(detypedName = "number-of-committed-transactions")
	public Long numberOfCommittedTransactions() {
		return this.numberOfCommittedTransactions;
	}

	/**
	 * The number of committed transactions.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfCommittedTransactions(java.lang.Long value) {
		Object oldValue = this.numberOfCommittedTransactions;
		this.numberOfCommittedTransactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfCommittedTransactions",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The number of transactions which have terminated with heuristic outcomes.
	 */
	@ModelNodeBinding(detypedName = "number-of-heuristics")
	public Long numberOfHeuristics() {
		return this.numberOfHeuristics;
	}

	/**
	 * The number of transactions which have terminated with heuristic outcomes.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfHeuristics(java.lang.Long value) {
		Object oldValue = this.numberOfHeuristics;
		this.numberOfHeuristics = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfHeuristics", oldValue, value);
		return (T) this;
	}

	/**
	 * The number of transactions that have begun but not yet terminated.
	 */
	@ModelNodeBinding(detypedName = "number-of-inflight-transactions")
	public Long numberOfInflightTransactions() {
		return this.numberOfInflightTransactions;
	}

	/**
	 * The number of transactions that have begun but not yet terminated.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfInflightTransactions(java.lang.Long value) {
		Object oldValue = this.numberOfInflightTransactions;
		this.numberOfInflightTransactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfInflightTransactions",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The total number of nested (sub) transactions created.
	 */
	@ModelNodeBinding(detypedName = "number-of-nested-transactions")
	public Long numberOfNestedTransactions() {
		return this.numberOfNestedTransactions;
	}

	/**
	 * The total number of nested (sub) transactions created.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfNestedTransactions(java.lang.Long value) {
		Object oldValue = this.numberOfNestedTransactions;
		this.numberOfNestedTransactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfNestedTransactions", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of transactions that rolled back due to resource (participant)
	 * failure.
	 */
	@ModelNodeBinding(detypedName = "number-of-resource-rollbacks")
	public Long numberOfResourceRollbacks() {
		return this.numberOfResourceRollbacks;
	}

	/**
	 * The number of transactions that rolled back due to resource (participant)
	 * failure.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfResourceRollbacks(java.lang.Long value) {
		Object oldValue = this.numberOfResourceRollbacks;
		this.numberOfResourceRollbacks = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfResourceRollbacks", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of transactions that have been rolled back due to internal
	 * system errors.
	 */
	@ModelNodeBinding(detypedName = "number-of-system-rollbacks")
	public Long numberOfSystemRollbacks() {
		return this.numberOfSystemRollbacks;
	}

	/**
	 * The number of transactions that have been rolled back due to internal
	 * system errors.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfSystemRollbacks(java.lang.Long value) {
		Object oldValue = this.numberOfSystemRollbacks;
		this.numberOfSystemRollbacks = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfSystemRollbacks", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The number of transactions that have rolled back due to timeout.
	 */
	@ModelNodeBinding(detypedName = "number-of-timed-out-transactions")
	public Long numberOfTimedOutTransactions() {
		return this.numberOfTimedOutTransactions;
	}

	/**
	 * The number of transactions that have rolled back due to timeout.
	 */
	@SuppressWarnings("unchecked")
	public T numberOfTimedOutTransactions(java.lang.Long value) {
		Object oldValue = this.numberOfTimedOutTransactions;
		this.numberOfTimedOutTransactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfTimedOutTransactions",
					oldValue, value);
		return (T) this;
	}

	/**
	 * The total number of transactions (top-level and nested) created
	 */
	@ModelNodeBinding(detypedName = "number-of-transactions")
	public Long numberOfTransactions() {
		return this.numberOfTransactions;
	}

	/**
	 * The total number of transactions (top-level and nested) created
	 */
	@SuppressWarnings("unchecked")
	public T numberOfTransactions(java.lang.Long value) {
		Object oldValue = this.numberOfTransactions;
		this.numberOfTransactions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("numberOfTransactions", oldValue, value);
		return (T) this;
	}

	/**
	 * Denotes a relative or absolute filesystem path denoting where the
	 * transaction manager object store should store data. By default the value
	 * is treated as relative to the path denoted by the "relative-to"
	 * attribute. This settings is valid when default or journal store is used.
	 * It's not used when jdbc journal store is used.
	 */
	@ModelNodeBinding(detypedName = "object-store-path")
	public String objectStorePath() {
		return this.objectStorePath;
	}

	/**
	 * Denotes a relative or absolute filesystem path denoting where the
	 * transaction manager object store should store data. By default the value
	 * is treated as relative to the path denoted by the "relative-to"
	 * attribute. This settings is valid when default or journal store is used.
	 * It's not used when jdbc journal store is used.
	 */
	@SuppressWarnings("unchecked")
	public T objectStorePath(java.lang.String value) {
		Object oldValue = this.objectStorePath;
		this.objectStorePath = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("objectStorePath", oldValue, value);
		return (T) this;
	}

	/**
	 * References a global path configuration in the domain model, defaulting to
	 * the Application Server data directory (jboss.server.data.dir). The value
	 * of the "Object store path" attribute will treated as relative to this
	 * path. Undefine this attribute to disable the default behavior and force
	 * the value of the "Object store path" attribute to be treated as an
	 * absolute path.
	 */
	@ModelNodeBinding(detypedName = "object-store-relative-to")
	public String objectStoreRelativeTo() {
		return this.objectStoreRelativeTo;
	}

	/**
	 * References a global path configuration in the domain model, defaulting to
	 * the Application Server data directory (jboss.server.data.dir). The value
	 * of the "Object store path" attribute will treated as relative to this
	 * path. Undefine this attribute to disable the default behavior and force
	 * the value of the "Object store path" attribute to be treated as an
	 * absolute path.
	 */
	@SuppressWarnings("unchecked")
	public T objectStoreRelativeTo(java.lang.String value) {
		Object oldValue = this.objectStoreRelativeTo;
		this.objectStoreRelativeTo = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("objectStoreRelativeTo", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The name of the socket binding configuration to use if the transaction
	 * manager should use a socket-based process id. Will be 'undefined' if
	 * 'process-id-uuid' is 'true'; otherwise must be set.
	 */
	@ModelNodeBinding(detypedName = "process-id-socket-binding")
	public String processIdSocketBinding() {
		return this.processIdSocketBinding;
	}

	/**
	 * The name of the socket binding configuration to use if the transaction
	 * manager should use a socket-based process id. Will be 'undefined' if
	 * 'process-id-uuid' is 'true'; otherwise must be set.
	 */
	@SuppressWarnings("unchecked")
	public T processIdSocketBinding(java.lang.String value) {
		Object oldValue = this.processIdSocketBinding;
		this.processIdSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("processIdSocketBinding", oldValue,
					value);
		return (T) this;
	}

	/**
	 * The maximum number of ports to search for an open port if the transaction
	 * manager should use a socket-based process id. If the port specified by
	 * the socket binding referenced in 'process-id-socket-binding' is occupied,
	 * the next higher port will be tried until an open port is found or the
	 * number of ports specified by this attribute have been tried. Will be
	 * 'undefined' if 'process-id-uuid' is 'true'.
	 */
	@ModelNodeBinding(detypedName = "process-id-socket-max-ports")
	public Integer processIdSocketMaxPorts() {
		return this.processIdSocketMaxPorts;
	}

	/**
	 * The maximum number of ports to search for an open port if the transaction
	 * manager should use a socket-based process id. If the port specified by
	 * the socket binding referenced in 'process-id-socket-binding' is occupied,
	 * the next higher port will be tried until an open port is found or the
	 * number of ports specified by this attribute have been tried. Will be
	 * 'undefined' if 'process-id-uuid' is 'true'.
	 */
	@SuppressWarnings("unchecked")
	public T processIdSocketMaxPorts(java.lang.Integer value) {
		Object oldValue = this.processIdSocketMaxPorts;
		this.processIdSocketMaxPorts = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("processIdSocketMaxPorts", oldValue,
					value);
		return (T) this;
	}

	/**
	 * Indicates whether the transaction manager should use a UUID based process
	 * id.
	 */
	@ModelNodeBinding(detypedName = "process-id-uuid")
	public Boolean processIdUuid() {
		return this.processIdUuid;
	}

	/**
	 * Indicates whether the transaction manager should use a UUID based process
	 * id.
	 */
	@SuppressWarnings("unchecked")
	public T processIdUuid(java.lang.Boolean value) {
		Object oldValue = this.processIdUuid;
		this.processIdUuid = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("processIdUuid", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to specify if the recovery system should listen on a network socket
	 * or not.
	 */
	@ModelNodeBinding(detypedName = "recovery-listener")
	public Boolean recoveryListener() {
		return this.recoveryListener;
	}

	/**
	 * Used to specify if the recovery system should listen on a network socket
	 * or not.
	 */
	@SuppressWarnings("unchecked")
	public T recoveryListener(java.lang.Boolean value) {
		Object oldValue = this.recoveryListener;
		this.recoveryListener = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("recoveryListener", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to reference the correct socket binding to use for the recovery
	 * environment.
	 */
	@ModelNodeBinding(detypedName = "socket-binding")
	public String socketBinding() {
		return this.socketBinding;
	}

	/**
	 * Used to reference the correct socket binding to use for the recovery
	 * environment.
	 */
	@SuppressWarnings("unchecked")
	public T socketBinding(java.lang.String value) {
		Object oldValue = this.socketBinding;
		this.socketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("socketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Whether transaction statistics should be gathered.
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Whether transaction statistics should be gathered.
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(java.lang.Boolean value) {
		Object oldValue = this.statisticsEnabled;
		this.statisticsEnabled = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statisticsEnabled", oldValue, value);
		return (T) this;
	}

	/**
	 * Used to reference the correct socket binding to use for the transaction
	 * status manager.
	 */
	@ModelNodeBinding(detypedName = "status-socket-binding")
	public String statusSocketBinding() {
		return this.statusSocketBinding;
	}

	/**
	 * Used to reference the correct socket binding to use for the transaction
	 * status manager.
	 */
	@SuppressWarnings("unchecked")
	public T statusSocketBinding(java.lang.String value) {
		Object oldValue = this.statusSocketBinding;
		this.statusSocketBinding = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("statusSocketBinding", oldValue, value);
		return (T) this;
	}

	/**
	 * Use the journal store for writing transaction logs. Set to true to enable
	 * and to false to use the default log store type. The default log store is
	 * normally one file system file per transaction log.It's alternative to
	 * jdbc based store.
	 */
	@ModelNodeBinding(detypedName = "use-hornetq-store")
	public Boolean useHornetqStore() {
		return this.useHornetqStore;
	}

	/**
	 * Use the journal store for writing transaction logs. Set to true to enable
	 * and to false to use the default log store type. The default log store is
	 * normally one file system file per transaction log.It's alternative to
	 * jdbc based store.
	 */
	@SuppressWarnings("unchecked")
	public T useHornetqStore(java.lang.Boolean value) {
		Object oldValue = this.useHornetqStore;
		this.useHornetqStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useHornetqStore", oldValue, value);
		return (T) this;
	}

	/**
	 * Use the jdbc store for writing transaction logs. Set to true to enable
	 * and to false to use the default log store type. The default log store is
	 * normally one file file per transaction log. It's alternative to journal
	 * based store.
	 */
	@ModelNodeBinding(detypedName = "use-jdbc-store")
	public Boolean useJdbcStore() {
		return this.useJdbcStore;
	}

	/**
	 * Use the jdbc store for writing transaction logs. Set to true to enable
	 * and to false to use the default log store type. The default log store is
	 * normally one file file per transaction log. It's alternative to journal
	 * based store.
	 */
	@SuppressWarnings("unchecked")
	public T useJdbcStore(java.lang.Boolean value) {
		Object oldValue = this.useJdbcStore;
		this.useJdbcStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useJdbcStore", oldValue, value);
		return (T) this;
	}

	/**
	 * Use the journal store for writing transaction logs. Set to true to enable
	 * and to false to use the default log store type. The default log store
	 * creates normally one file system file per transaction log. The journal
	 * one consists from one file for all the transactions. It's alternative to
	 * jdbc based store.
	 */
	@ModelNodeBinding(detypedName = "use-journal-store")
	public Boolean useJournalStore() {
		return this.useJournalStore;
	}

	/**
	 * Use the journal store for writing transaction logs. Set to true to enable
	 * and to false to use the default log store type. The default log store
	 * creates normally one file system file per transaction log. The journal
	 * one consists from one file for all the transactions. It's alternative to
	 * jdbc based store.
	 */
	@SuppressWarnings("unchecked")
	public T useJournalStore(java.lang.Boolean value) {
		Object oldValue = this.useJournalStore;
		this.useJournalStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useJournalStore", oldValue, value);
		return (T) this;
	}
}