package org.wildfly.swarm.config;

import org.wildfly.swarm.config.BatchJBeret;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface BatchJBeretConsumer<T extends BatchJBeret<T>> {

	/**
	 * Configure a pre-constructed instance of BatchJBeret resource
	 * 
	 * @parameter Instance of BatchJBeret to configure
	 * @return nothing
	 */
	void accept(T value);

	default BatchJBeretConsumer<T> andThen(BatchJBeretConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}