/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.wildfly.security.authz.Roles;

class MappedRoles
implements Roles {
    private final Roles delegate;
    private final Map<String, Set<String>> reverseRoleMap;

    public MappedRoles(Roles delegate, Map<String, Set<String>> reverseRoleMap) {
        this.delegate = delegate;
        this.reverseRoleMap = reverseRoleMap;
    }

    @Override
    public boolean contains(String roleName) {
        Set<String> rolesToContain = this.reverseRoleMap.get(roleName);
        if (rolesToContain == null) {
            return false;
        }
        return this.delegate.containsAny(rolesToContain);
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator<String> iterator = this.reverseRoleMap.keySet().iterator();
        return new Iterator<String>(){
            String next = null;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (iterator.hasNext()) {
                    String nextt = (String)iterator.next();
                    if (!MappedRoles.this.delegate.containsAny(MappedRoles.this.reverseRoleMap.get(nextt))) continue;
                    this.next = nextt;
                    return true;
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String next = this.next;
                this.next = null;
                return next;
            }
        };
    }
}

