/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.dynamic.ssl;

import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.wildfly.security.auth.client.ActiveSessionsSSLContext;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextException;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextSPI;
import org.wildfly.security.dynamic.ssl.DynamicSSLContextSpiImpl;

public final class DynamicSSLContext
extends SSLContext
implements ActiveSessionsSSLContext {
    private static SSLContext resolverSSLContext(DynamicSSLContextSPI dynamicSSLContextSPIImpl) throws NoSuchAlgorithmException, DynamicSSLContextException {
        return dynamicSSLContextSPIImpl.getConfiguredDefault() == null ? SSLContext.getDefault() : dynamicSSLContextSPIImpl.getConfiguredDefault();
    }

    public DynamicSSLContext() throws NoSuchAlgorithmException {
        super(new DynamicSSLContextSpiImpl(), SSLContext.getDefault().getProvider(), SSLContext.getDefault().getProtocol());
    }

    public DynamicSSLContext(DynamicSSLContextSPI dynamicSSLContextSPIImpl) throws NoSuchAlgorithmException, DynamicSSLContextException {
        super(new DynamicSSLContextSpiImpl(dynamicSSLContextSPIImpl), DynamicSSLContext.resolverSSLContext(dynamicSSLContextSPIImpl).getProvider(), DynamicSSLContext.resolverSSLContext(dynamicSSLContextSPIImpl).getProtocol());
    }
}

