/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.RuleNode;
import org.wildfly.security.auth.client._private.ElytronMessages;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.permission.ElytronPermission;

public final class AuthenticationContextConfigurationClient {
    private static final ElytronPermission CREATE_PERMISSION = new ElytronPermission("createAuthenticationContextConfigurationClient");
    public static final PrivilegedAction<AuthenticationContextConfigurationClient> ACTION = AuthenticationContextConfigurationClient::new;

    public AuthenticationContextConfigurationClient() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, -1);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, protocolDefaultPort, null, null);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort, String abstractType, String abstractTypeAuthority) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        RuleNode<AuthenticationConfiguration> node = authenticationContext.authRuleMatching(uri, abstractType, abstractTypeAuthority);
        AuthenticationConfiguration configuration = node != null ? node.getConfiguration() : AuthenticationConfiguration.empty();
        configuration = AuthenticationContextConfigurationClient.initializeConfiguration(uri, configuration);
        configuration = AuthenticationContextConfigurationClient.establishOverrides(uri, protocolDefaultPort, configuration);
        ElytronMessages.log.tracef("getAuthenticationConfiguration uri=%s, protocolDefaultPort=%d, abstractType=%s, abstractTypeAuthority=%s, MatchRule=[%s], AuthenticationConfiguration=[%s]", uri, protocolDefaultPort, abstractType, abstractTypeAuthority, node != null ? node.rule : null, configuration);
        return configuration;
    }

    public AuthenticationConfiguration getAuthenticationConfigurationNoOverrides(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        RuleNode<AuthenticationConfiguration> node = authenticationContext.authRuleMatching(uri, abstractType, abstractTypeAuthority);
        AuthenticationConfiguration configuration = node != null ? node.getConfiguration() : AuthenticationConfiguration.empty();
        configuration = AuthenticationContextConfigurationClient.initializeConfiguration(uri, configuration);
        ElytronMessages.log.tracef("getAuthenticationConfiguration uri=%s, abstractType=%s, abstractTypeAuthority=%s, MatchRule=[%s], AuthenticationConfiguration=[%s]", uri, abstractType, abstractTypeAuthority, node != null ? node.rule : null, configuration);
        return configuration;
    }

    private static AuthenticationConfiguration establishOverrides(URI uri, int protocolDefaultPort, AuthenticationConfiguration configuration) {
        String scheme;
        int port;
        String uriHost = uri.getHost();
        if (uriHost != null && configuration.setHost == null) {
            configuration = configuration.useHost(uriHost);
        }
        if ((port = uri.getPort()) == -1) {
            port = protocolDefaultPort;
        }
        if (port != -1 && configuration.setPort == -1) {
            configuration = configuration.usePort(port);
        }
        if ((scheme = uri.getScheme()) != null && configuration.setProtocol == null) {
            configuration = configuration.useProtocol(scheme);
        }
        return configuration;
    }

    private static AuthenticationConfiguration initializeConfiguration(URI uri, AuthenticationConfiguration configuration) {
        AccessControlContext capturedContext;
        SecurityDomain authenticationCredentialsForwardSecurityDomain;
        SecurityDomain authenticationNameForwardSecurityDomain = configuration.authenticationNameForwardSecurityDomain;
        String userInfo = uri.getUserInfo();
        if (userInfo != null && configuration.getPrincipal() == AnonymousPrincipal.getInstance() && authenticationNameForwardSecurityDomain == null) {
            configuration = configuration.useName(userInfo);
        }
        if (authenticationNameForwardSecurityDomain != null) {
            configuration = configuration.useForwardedAuthenticationIdentity(null).usePrincipal(authenticationNameForwardSecurityDomain.getCurrentSecurityIdentity().getPrincipal());
        }
        if ((authenticationCredentialsForwardSecurityDomain = configuration.authenticationCredentialsForwardSecurityDomain) != null) {
            SecurityIdentity securityIdentity = authenticationCredentialsForwardSecurityDomain.getCurrentSecurityIdentity();
            IdentityCredentials privateCredentials = securityIdentity.getPrivateCredentials();
            IdentityCredentials publicCredentials = securityIdentity.getPublicCredentials();
            configuration = configuration.useForwardedAuthenticationCredentials(null).useCredentials(publicCredentials.with(privateCredentials));
        }
        configuration = configuration.captureAuthorizationIdentity();
        if (AuthenticationConfiguration.WILDFLY_ELYTRON_CAPTURE_ACCESS_CONTROL_CONTEXT_PROPERTY && (capturedContext = configuration.getCapturedContext()) == null) {
            configuration = configuration.withCapturedAccessControlContext();
        }
        return configuration;
    }

    public SSLContext getSSLContext(AuthenticationContext authenticationContext) throws GeneralSecurityException {
        return this.getSSLContext(null, authenticationContext, null, null);
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext) throws GeneralSecurityException {
        return this.getSSLContext(uri, authenticationContext, null, null);
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority) throws GeneralSecurityException {
        return this.getSSLContextFactory(uri, authenticationContext, abstractType, abstractTypeAuthority).create();
    }

    public SecurityFactory<SSLContext> getSSLContextFactory(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority) {
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        RuleNode<SecurityFactory<SSLContext>> node = authenticationContext.sslRuleMatching(uri, abstractType, abstractTypeAuthority);
        if (node == null) {
            return SSLContext::getDefault;
        }
        return node.getConfiguration();
    }

    public CallbackHandler getCallbackHandler(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        CallbackHandler callbackHandler = configuration.getUserCallbackHandler();
        return callbackHandler == null ? configuration.createCallbackHandler() : callbackHandler;
    }

    @Deprecated
    public String getRealHost(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        String configurationHost = configuration.getHost();
        return configurationHost == null ? uri.getHost() : configurationHost;
    }

    @Deprecated
    public String getRealHost(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getHost();
    }

    @Deprecated
    public int getRealPort(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        int configurationPort = configuration.getPort();
        return configurationPort == -1 ? uri.getPort() : configurationPort;
    }

    @Deprecated
    public int getRealPort(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getPort();
    }

    @Deprecated
    public String getRealProtocol(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        String protocol = configuration.getProtocol();
        return protocol == null ? uri.getScheme() : protocol;
    }

    @Deprecated
    public String getRealProtocol(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getProtocol();
    }

    public String getSaslProtocol(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getSaslProtocol();
    }

    public String getWsHttpMech(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getWsHttpMechanism();
    }

    public String getWsSecurityType(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getWsSecurityType();
    }

    public Principal getPrincipal(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getPrincipal();
    }

    public Principal getAuthorizationPrincipal(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getAuthorizationPrincipal();
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, Collection<String> offeredMechanisms) throws SaslException {
        return this.createSaslClient(uri, configuration, offeredMechanisms, UnaryOperator.identity());
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, Collection<String> offeredMechanisms, UnaryOperator<SaslClientFactory> factoryOperator) throws SaslException {
        return this.createSaslClient(uri, configuration, offeredMechanisms, factoryOperator, null);
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, Collection<String> offeredMechanisms, UnaryOperator<SaslClientFactory> factoryOperator, SSLSession sslSession) throws SaslException {
        return configuration.createSaslClient(uri, offeredMechanisms, factoryOperator, sslSession);
    }

    @Deprecated
    public InetSocketAddress getDestinationInetSocketAddress(URI uri, AuthenticationConfiguration configuration, int protocolDefaultPort) {
        int port;
        Assert.checkNotNullParam((String)"uri", (Object)uri);
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        String host = configuration.getHost();
        if (host == null) {
            host = uri.getHost();
        }
        if ((port = configuration.getPort()) == -1) {
            port = uri.getPort();
        }
        if (port == -1) {
            port = protocolDefaultPort;
        }
        return new InetSocketAddress(host, port);
    }

    @Deprecated
    public InetSocketAddress getDestinationInetSocketAddress(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return new InetSocketAddress(configuration.getHost(), configuration.getPort());
    }

    @Deprecated
    public Socket connect(URI uri, AuthenticationConfiguration configuration, int protocolDefaultPort) throws IOException {
        InetSocketAddress address = this.getDestinationInetSocketAddress(uri, configuration, protocolDefaultPort);
        return new Socket(address.getAddress(), address.getPort());
    }

    public Supplier<Provider[]> getProviderSupplier(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        return configuration.getProviderSupplier();
    }
}

