/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.jose.jwk;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.wildfly.security.jose.jwk.JWK;
import org.wildfly.security.jose.jwk.JWKParser;
import org.wildfly.security.jose.jwk.JsonWebKeySet;

public class JsonWebKeySetUtil {
    public static Predicate<JWK> SUPPORTED_KEY_TYPE = j -> JWKParser.isKeyTypeSupported(j.getKeyType());
    public static Predicate<JWK> FOR_SIGNATURE_VALIDATION = SUPPORTED_KEY_TYPE.and(JsonWebKeySetUtil.usePredicate(JWK.Use.SIG).or(JsonWebKeySetUtil.keyOpsPredicate(JWK.KeyOp.VERIFY)));
    public static Predicate<JWK> FOR_ENCRYPTION = SUPPORTED_KEY_TYPE.and(JsonWebKeySetUtil.usePredicate(JWK.Use.ENC).or(JsonWebKeySetUtil.keyOpsPredicate(JWK.KeyOp.ENCRYPT)));

    public static Map<String, PublicKey> getKeys(JsonWebKeySet keySet, Predicate<JWK> keyPredicate) {
        HashMap<String, PublicKey> result = new HashMap<String, PublicKey>();
        for (JWK jwk : keySet.getKeys()) {
            if (!keyPredicate.test(jwk)) continue;
            result.put(jwk.getKeyId(), JWKParser.toPublicKey(jwk));
        }
        return result;
    }

    public static Predicate<JWK> usePredicate(JWK.Use requestedUse) {
        return j -> j.getPublicKeyUse() != null && j.getPublicKeyUse().equals(requestedUse.asString());
    }

    public static Predicate<JWK> keyOpsPredicate(JWK.KeyOp requestedKeyOp) {
        return j -> {
            String[] keyOps = j.getKeyOps();
            if (keyOps != null) {
                for (String keyOp : keyOps) {
                    if (!keyOp.equals(requestedKeyOp.asString())) continue;
                    return true;
                }
            }
            return false;
        };
    }
}

