/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.security.Permission;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.permission.ElytronMessages;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.wildfly.security.permission.PermissionVerifier;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String permissionCollectionMustBeReadOnly = "ELY03013: Permission collection must be read-only";
    private static final String permissionClassMissing = "ELY03015: Could not load permission class \"%s\"";
    private static final String permissionInstantiation = "ELY03016: Could not instantiate permission class \"%s\"";
    private static final String noPermissionConstructor = "ELY03017: No valid permission constructor found on class \"%s\"";
    private static final String readOnlyPermissionCollection = "ELY03018: Cannot add permissions to a read-only permission collection";
    private static final String invalidObjectNull = "ELY03019: Failure to deserialize object: field \"%s\" is null";
    private static final String expectedEmptyActions = "ELY03020: Expected empty actions string, got \"%s\"";
    private static final String invalidPermissionType = "ELY03021: Invalid permission type; expected %s, got %s";
    private static final String permissionCheckFailed = "ELY03022: Permission check failed: %s is not implied by %s";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String permissionCollectionMustBeReadOnly$str() {
        return permissionCollectionMustBeReadOnly;
    }

    @Override
    public final SecurityException permissionCollectionMustBeReadOnly() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.permissionCollectionMustBeReadOnly$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionClassMissing$str() {
        return permissionClassMissing;
    }

    @Override
    public final InvalidPermissionClassException permissionClassMissing(String className, ClassNotFoundException cause) {
        InvalidPermissionClassException result = new InvalidPermissionClassException(String.format(this.getLoggingLocale(), this.permissionClassMissing$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionInstantiation$str() {
        return permissionInstantiation;
    }

    @Override
    public final InvalidPermissionClassException permissionInstantiation(String className, Throwable cause) {
        InvalidPermissionClassException result = new InvalidPermissionClassException(String.format(this.getLoggingLocale(), this.permissionInstantiation$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPermissionConstructor$str() {
        return noPermissionConstructor;
    }

    @Override
    public final InvalidPermissionClassException noPermissionConstructor(String className) {
        InvalidPermissionClassException result = new InvalidPermissionClassException(String.format(this.getLoggingLocale(), this.noPermissionConstructor$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String readOnlyPermissionCollection$str() {
        return readOnlyPermissionCollection;
    }

    @Override
    public final SecurityException readOnlyPermissionCollection() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.readOnlyPermissionCollection$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidObjectNull$str() {
        return invalidObjectNull;
    }

    @Override
    public final InvalidObjectException invalidObjectNull(String fieldName) {
        InvalidObjectException result = new InvalidObjectException(String.format(this.getLoggingLocale(), this.invalidObjectNull$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expectedEmptyActions$str() {
        return expectedEmptyActions;
    }

    @Override
    public final IllegalArgumentException expectedEmptyActions(String actions) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expectedEmptyActions$str(), actions));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPermissionType$str() {
        return invalidPermissionType;
    }

    @Override
    public final IllegalArgumentException invalidPermissionType(Class<? extends Permission> expected, Permission actual) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPermissionType$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String permissionCheckFailed$str() {
        return permissionCheckFailed;
    }

    @Override
    public final SecurityException permissionCheckFailed(Permission permission, PermissionVerifier permissionVerifier) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.permissionCheckFailed$str(), permission, permissionVerifier));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

