/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.token._private;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.realm.token._private.ElytronMessages;
import org.wildfly.security.auth.server.RealmUnavailableException;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String tokenRealmFailedToObtainPrincipal = "ELY01104: OAuth2-based realm failed to obtain principal";
    private static final String tokenRealmOAuth2TokenIntrospectionFailed = "ELY01105: OAuth2-based realm failed to introspect token";
    private static final String tokenRealmFailedToObtainPrincipalWithClaim = "ELY01113: Token-based realm failed to obtain principal from token using claim [%s]";
    private static final String tokenRealmJwtInvalidFormat = "ELY01114: Invalid token format. Tokens must have a signature part accordingly with JWS specification";
    private static final String tokenRealmJwtParseFailed = "ELY01115: Failed to parse token";
    private static final String tokenRealmJwtSignatureCheckFailed = "ELY01116: Signature verification failed";
    private static final String tokenRealmJwtSignatureInvalidAlgorithm = "ELY01117: Invalid signature algorithm [%s]";
    private static final String tokenRealmJwtInvalidPublicKeyPem = "ELY01118: Public key could not be obtained. Probably due to an invalid PEM format.";
    private static final String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck = "ELY01126: Jwt-based token realm not configured with a list of valid issuers. Ignoring issuer verification.";
    private static final String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck = "ELY01127: Jwt-based token not configured with a list of valid audiences. Ignoring audience verification.";
    private static final String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck = "ELY01128: Jwt-based token not configured with a public key. Ignoring signature verification.";
    private static final String unableToFetchJwks = "ELY01178: Unable to update jwk set from \"%1$s\".";
    private static final String tokenRealmJwtNoSSLIgnoringJku = "ELY01179: SSL not configured. jku claim will not be supported.";
    private static final String tokenRealmJwkMissingClaim = "ELY01180: Fetched jwk does not contain \"%1$s\" claim, ignoring...";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String tokenRealmFailedToObtainPrincipal$str() {
        return tokenRealmFailedToObtainPrincipal;
    }

    @Override
    public final RuntimeException tokenRealmFailedToObtainPrincipal(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.tokenRealmFailedToObtainPrincipal$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenRealmOAuth2TokenIntrospectionFailed$str() {
        return tokenRealmOAuth2TokenIntrospectionFailed;
    }

    @Override
    public final RealmUnavailableException tokenRealmOAuth2TokenIntrospectionFailed(Throwable cause) {
        RealmUnavailableException result = new RealmUnavailableException(String.format(this.getLoggingLocale(), this.tokenRealmOAuth2TokenIntrospectionFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenRealmFailedToObtainPrincipalWithClaim$str() {
        return tokenRealmFailedToObtainPrincipalWithClaim;
    }

    @Override
    public final IllegalStateException tokenRealmFailedToObtainPrincipalWithClaim(String claimName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tokenRealmFailedToObtainPrincipalWithClaim$str(), claimName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenRealmJwtInvalidFormat$str() {
        return tokenRealmJwtInvalidFormat;
    }

    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidFormat() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.tokenRealmJwtInvalidFormat$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenRealmJwtParseFailed$str() {
        return tokenRealmJwtParseFailed;
    }

    @Override
    public final IllegalStateException tokenRealmJwtParseFailed(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tokenRealmJwtParseFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenRealmJwtSignatureCheckFailed$str() {
        return tokenRealmJwtSignatureCheckFailed;
    }

    @Override
    public final IllegalStateException tokenRealmJwtSignatureCheckFailed(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tokenRealmJwtSignatureCheckFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenRealmJwtSignatureInvalidAlgorithm$str() {
        return tokenRealmJwtSignatureInvalidAlgorithm;
    }

    @Override
    public final IllegalArgumentException tokenRealmJwtSignatureInvalidAlgorithm(String algorithm) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.tokenRealmJwtSignatureInvalidAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String tokenRealmJwtInvalidPublicKeyPem$str() {
        return tokenRealmJwtInvalidPublicKeyPem;
    }

    @Override
    public final IllegalArgumentException tokenRealmJwtInvalidPublicKeyPem() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.tokenRealmJwtInvalidPublicKeyPem$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str(), new Object[0]);
    }

    protected String tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck$str() {
        return tokenRealmJwtWarnNoIssuerIgnoringIssuerCheck;
    }

    @Override
    public final void tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str(), new Object[0]);
    }

    protected String tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck$str() {
        return tokenRealmJwtWarnNoAudienceIgnoringAudienceCheck;
    }

    @Override
    public final void tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str(), new Object[0]);
    }

    protected String tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck$str() {
        return tokenRealmJwtWarnNoPublicKeyIgnoringSignatureCheck;
    }

    @Override
    public final void unableToFetchJwks(String url) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.unableToFetchJwks$str(), (Object)url);
    }

    protected String unableToFetchJwks$str() {
        return unableToFetchJwks;
    }

    @Override
    public final void tokenRealmJwtNoSSLIgnoringJku() {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)null, this.tokenRealmJwtNoSSLIgnoringJku$str(), new Object[0]);
    }

    protected String tokenRealmJwtNoSSLIgnoringJku$str() {
        return tokenRealmJwtNoSSLIgnoringJku;
    }

    @Override
    public final void tokenRealmJwkMissingClaim(String claim) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.tokenRealmJwkMissingClaim$str(), (Object)claim);
    }

    protected String tokenRealmJwkMissingClaim$str() {
        return tokenRealmJwkMissingClaim;
    }
}

