/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.io.Serializable;
import java.security.cert.CertificateException;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.x500.cert.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String malformedPemContent = "ELY03010: Malformed PEM content at offset %d";
    private static final String invalidPemType = "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    private static final String certificateParseError = "ELY03012: Certificate parse error";
    private static final String publicKeyParseError = "ELY03023: PublicKey parse error";
    private static final String privateKeyParseError = "ELY03033: PrivateKey parse error";
    private static final String asnUnrecognisedAlgorithm = "ELY07001: Unrecognized encoding algorithm [%s]";
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";
    private static final String extensionAlreadyExists = "ELY10000: X.509 certificate extension with OID %s already exists";
    private static final String noSignatureAlgorithmNameGiven = "ELY10001: No signature algorithm name given";
    private static final String unknownSignatureAlgorithmName = "ELY10002: Signature algorithm name \"%s\" is not recognized";
    private static final String noSigningKeyGiven = "ELY10003: No signing key given";
    private static final String signingKeyNotCompatWithSig = "ELY10004: Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"";
    private static final String validAfterBeforeValidBefore = "ELY10005: Not-valid-before date of %s is after not-valid-after date of %s";
    private static final String noIssuerDnGiven = "ELY10006: No issuer DN given";
    private static final String noPublicKeyGiven = "ELY10007: No public key given";
    private static final String uniqueIdNotAllowed = "ELY10008: Issuer and subject unique ID are only allowed in certificates with version 2 or higher";
    private static final String extensionsNotAllowed = "ELY10009: Extensions are only allowed in certificates with version 3 or higher";
    private static final String invalidKeyForCert = "ELY10010: X.509 encoding of public key with algorithm \"%s\" failed";
    private static final String certSigningFailed = "ELY10011: Failed to sign certificate";
    private static final String serialNumberTooSmall = "ELY10012: Certificate serial number must be positive";
    private static final String serialNumberTooLarge = "ELY10013: Certificate serial number too large (cannot exceed 20 octets)";
    private static final String certRequestInfoSigningFailed = "ELY10014: Failed to sign certification request info";
    private static final String noCertificateGiven = "ELY10015: No certificate given";
    private static final String noDnGiven = "ELY10017: No DN given";
    private static final String selfSignedCertificateGenerationFailed = "ELY10018: Failed to generate self-signed X.509 certificate";
    private static final String unableToDetermineDefaultCompatibleSignatureAlgorithmName = "ELY10019: Unable to determine default compatible signature algorithm name for key algorithm name \"%s\"";
    private static final String certificateExtensionCreationFromStringNotSupported = "ELY10020: Creating an X.509 certificate extension from a string value is not supported for extension name \"%s\"";
    private static final String invalidCertificateExtensionStringValue1 = "ELY10021: Invalid X.509 certificate extension string value \"%s\"";
    private static final String certificateExtensionCreationFromStringFailed = "ELY10022: Failed to create X.509 certificate extension from string value";
    private static final String certificateExtensionMustBeNonCritical = "ELY10023: X.509 certificate extension \"%s\" must be non-critical";
    private static final String invalidCertificateExtensionStringValue0 = "ELY10024: Invalid X.509 certificate extension string value";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String malformedPemContent$str() {
        return malformedPemContent;
    }

    @Override
    public final IllegalArgumentException malformedPemContent(long offset) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.malformedPemContent$str(), offset));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPemType$str() {
        return invalidPemType;
    }

    @Override
    public final IllegalArgumentException invalidPemType(String expected, String actual) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPemType$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateParseError$str() {
        return certificateParseError;
    }

    @Override
    public final IllegalArgumentException certificateParseError(CertificateException cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateParseError$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String publicKeyParseError$str() {
        return publicKeyParseError;
    }

    @Override
    public final IllegalArgumentException publicKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyParseError$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String privateKeyParseError$str() {
        return privateKeyParseError;
    }

    @Override
    public final IllegalArgumentException privateKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.privateKeyParseError$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnUnrecognisedAlgorithm$str() {
        return asnUnrecognisedAlgorithm;
    }

    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(String algorithm) {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnrecognisedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }

    @Override
    public final ASN1Exception asnUnexpectedTag() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnexpectedTag$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionAlreadyExists$str() {
        return extensionAlreadyExists;
    }

    @Override
    public final IllegalArgumentException extensionAlreadyExists(String oid) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.extensionAlreadyExists$str(), oid));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSignatureAlgorithmNameGiven$str() {
        return noSignatureAlgorithmNameGiven;
    }

    @Override
    public final IllegalArgumentException noSignatureAlgorithmNameGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSignatureAlgorithmNameGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownSignatureAlgorithmName$str() {
        return unknownSignatureAlgorithmName;
    }

    @Override
    public final IllegalArgumentException unknownSignatureAlgorithmName(String signatureAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownSignatureAlgorithmName$str(), signatureAlgorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSigningKeyGiven$str() {
        return noSigningKeyGiven;
    }

    @Override
    public final IllegalArgumentException noSigningKeyGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noSigningKeyGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String signingKeyNotCompatWithSig$str() {
        return signingKeyNotCompatWithSig;
    }

    @Override
    public final IllegalArgumentException signingKeyNotCompatWithSig(String signingKeyAlgorithm, String signatureAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signingKeyNotCompatWithSig$str(), signingKeyAlgorithm, signatureAlgorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String validAfterBeforeValidBefore$str() {
        return validAfterBeforeValidBefore;
    }

    @Override
    public final IllegalArgumentException validAfterBeforeValidBefore(ZonedDateTime notValidBefore, ZonedDateTime notValidAfter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.validAfterBeforeValidBefore$str(), notValidBefore, notValidAfter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noIssuerDnGiven$str() {
        return noIssuerDnGiven;
    }

    @Override
    public final IllegalArgumentException noIssuerDnGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noIssuerDnGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noPublicKeyGiven$str() {
        return noPublicKeyGiven;
    }

    @Override
    public final IllegalArgumentException noPublicKeyGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noPublicKeyGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String uniqueIdNotAllowed$str() {
        return uniqueIdNotAllowed;
    }

    @Override
    public final IllegalArgumentException uniqueIdNotAllowed() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.uniqueIdNotAllowed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String extensionsNotAllowed$str() {
        return extensionsNotAllowed;
    }

    @Override
    public final IllegalArgumentException extensionsNotAllowed() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.extensionsNotAllowed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidKeyForCert$str() {
        return invalidKeyForCert;
    }

    @Override
    public final IllegalArgumentException invalidKeyForCert(String publicKeyAlgorithm, Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidKeyForCert$str(), publicKeyAlgorithm), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certSigningFailed$str() {
        return certSigningFailed;
    }

    @Override
    public final IllegalArgumentException certSigningFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certSigningFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serialNumberTooSmall$str() {
        return serialNumberTooSmall;
    }

    @Override
    public final IllegalArgumentException serialNumberTooSmall() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.serialNumberTooSmall$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serialNumberTooLarge$str() {
        return serialNumberTooLarge;
    }

    @Override
    public final IllegalArgumentException serialNumberTooLarge() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.serialNumberTooLarge$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certRequestInfoSigningFailed$str() {
        return certRequestInfoSigningFailed;
    }

    @Override
    public final IllegalArgumentException certRequestInfoSigningFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certRequestInfoSigningFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noCertificateGiven$str() {
        return noCertificateGiven;
    }

    @Override
    public final IllegalArgumentException noCertificateGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noCertificateGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDnGiven$str() {
        return noDnGiven;
    }

    @Override
    public final IllegalArgumentException noDnGiven() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noDnGiven$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String selfSignedCertificateGenerationFailed$str() {
        return selfSignedCertificateGenerationFailed;
    }

    @Override
    public final IllegalArgumentException selfSignedCertificateGenerationFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.selfSignedCertificateGenerationFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineDefaultCompatibleSignatureAlgorithmName$str() {
        return unableToDetermineDefaultCompatibleSignatureAlgorithmName;
    }

    @Override
    public final IllegalArgumentException unableToDetermineDefaultCompatibleSignatureAlgorithmName(String keyAlgorithmName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToDetermineDefaultCompatibleSignatureAlgorithmName$str(), keyAlgorithmName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateExtensionCreationFromStringNotSupported$str() {
        return certificateExtensionCreationFromStringNotSupported;
    }

    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringNotSupported(String extensionName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateExtensionCreationFromStringNotSupported$str(), extensionName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCertificateExtensionStringValue1$str() {
        return invalidCertificateExtensionStringValue1;
    }

    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue(String extensionValue) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCertificateExtensionStringValue1$str(), extensionValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateExtensionCreationFromStringFailed$str() {
        return certificateExtensionCreationFromStringFailed;
    }

    @Override
    public final IllegalArgumentException certificateExtensionCreationFromStringFailed(Exception cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateExtensionCreationFromStringFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateExtensionMustBeNonCritical$str() {
        return certificateExtensionMustBeNonCritical;
    }

    @Override
    public final IllegalArgumentException certificateExtensionMustBeNonCritical(String extensionName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateExtensionMustBeNonCritical$str(), extensionName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidCertificateExtensionStringValue0$str() {
        return invalidCertificateExtensionStringValue0;
    }

    @Override
    public final IllegalArgumentException invalidCertificateExtensionStringValue() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidCertificateExtensionStringValue0$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

