/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.security.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.wildfly.security.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.WildFlyElytronKeyProvider;
import org.wildfly.security.WildFlyElytronKeyStoreProvider;
import org.wildfly.security.WildFlyElytronPasswordProvider;
import org.wildfly.security.WildFlyElytronSaslAnonymousProvider;
import org.wildfly.security.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.WildFlyElytronSaslEntityProvider;
import org.wildfly.security.WildFlyElytronSaslExternalProvider;
import org.wildfly.security.WildFlyElytronSaslGs2Provider;
import org.wildfly.security.WildFlyElytronSaslGssapiProvider;
import org.wildfly.security.WildFlyElytronSaslLocalUserProvider;
import org.wildfly.security.WildFlyElytronSaslOAuth2Provider;
import org.wildfly.security.WildFlyElytronSaslOTPProvider;
import org.wildfly.security.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.WildFlyElytronSaslScramProvider;
import org.wildfly.security.util.ProviderUtil;
import org.wildfly.security.util.ServiceLoaderSupplier;

public class ProviderServiceLoaderSupplier
extends ServiceLoaderSupplier<Provider> {
    final boolean elytronProviderStaticallyAdded;

    public ProviderServiceLoaderSupplier(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public ProviderServiceLoaderSupplier(ClassLoader classLoader, boolean elytronProviderStaticallyAdded) {
        super(Provider.class, classLoader);
        this.elytronProviderStaticallyAdded = elytronProviderStaticallyAdded;
    }

    Provider[] loadServices(Class<Provider> service, ClassLoader classLoader) {
        Provider[] providers = ProviderUtil.INSTALLED_PROVIDERS.get();
        HashSet installedProvidersSet = new HashSet((providers != null ? providers.length : 0) + (this.elytronProviderStaticallyAdded ? 15 : 0));
        if (this.elytronProviderStaticallyAdded) {
            installedProvidersSet.add(WildFlyElytronPasswordProvider.class);
            installedProvidersSet.add(WildFlyElytronCredentialStoreProvider.class);
            installedProvidersSet.add(WildFlyElytronKeyProvider.class);
            installedProvidersSet.add(WildFlyElytronKeyStoreProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslAnonymousProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslDigestProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslEntityProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslExternalProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslGs2Provider.class);
            installedProvidersSet.add(WildFlyElytronSaslGssapiProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslLocalUserProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslOAuth2Provider.class);
            installedProvidersSet.add(WildFlyElytronSaslOTPProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslPlainProvider.class);
            installedProvidersSet.add(WildFlyElytronSaslScramProvider.class);
        }
        if (providers != null) {
            for (int i = 0; i < providers.length; ++i) {
                installedProvidersSet.add(providers[i].getClass());
            }
        }
        ArrayList<Provider> list = new ArrayList<Provider>();
        ServiceLoader<Provider> loader = ServiceLoader.load(service, classLoader);
        Iterator<Provider> iterator = loader.iterator();
        while (true) {
            try {
                while (true) {
                    if (!iterator.hasNext()) {
                        return list.toArray(new Provider[list.size()]);
                    }
                    Provider provider = iterator.next();
                    if (installedProvidersSet.contains(provider.getClass())) continue;
                    list.add(provider);
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ProviderServiceLoaderSupplier && this.equals((ProviderServiceLoaderSupplier)obj);
    }

    private boolean equals(ProviderServiceLoaderSupplier other) {
        return other == this || other.classLoader == this.classLoader;
    }
}

