/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.cache;

import java.io.Serializable;
import java.security.Principal;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.server.SecurityIdentity;

public final class CachedIdentity
implements Serializable {
    private static final long serialVersionUID = 750487522862481938L;
    private final String mechanismName;
    private final String name;
    private final transient SecurityIdentity securityIdentity;

    public CachedIdentity(String mechanismName, SecurityIdentity securityIdentity) {
        this(mechanismName, securityIdentity, () -> ((SecurityIdentity)Assert.checkNotNullParam((String)"securityIdentity", (Object)securityIdentity)).getPrincipal());
    }

    public CachedIdentity(String mechanismName, Principal principal) {
        this(mechanismName, null, () -> principal);
    }

    private CachedIdentity(String mechanismName, SecurityIdentity securityIdentity, Supplier<Principal> principalSupplier) {
        this.mechanismName = (String)Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        this.name = (String)Assert.checkNotNullParam((String)"name", (Object)((Principal)Assert.checkNotNullParam((String)"principal", (Object)principalSupplier.get())).getName());
        this.securityIdentity = securityIdentity;
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    public String getName() {
        return this.name;
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public String toString() {
        return "CachedIdentity{" + this.mechanismName + ", '" + this.name + "', " + this.securityIdentity + "}";
    }
}

