/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.scram;

import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Locale;

public enum ScramServerErrorCode {
    INVALID_ENCODING,
    EXTENSIONS_NOT_SUPPORTED,
    INVALID_PROOF,
    CHANNEL_BINDINGS_DONT_MATCH,
    SERVER_DOES_NOT_SUPPORT_CHANNEL_BINDING,
    SERVER_DOES_SUPPORT_CHANNEL_BINDING,
    CHANNEL_BINDING_NOT_SUPPORTED,
    CHANNEL_BINDING_NOT_PROVIDED,
    UNSUPPORTED_CHANNEL_BINDING_TYPE,
    UNKNOWN_USER,
    INVALID_USERNAME_ENCODING,
    NO_RESOURCES,
    OTHER_ERROR;

    private final String text = this.name().replace('_', '-').toLowerCase(Locale.US);
    private final byte[] messageBytes;
    private static final int fullSize;

    private ScramServerErrorCode() {
        int length = this.text.length();
        byte[] msg = new byte[length + 2];
        msg[0] = 101;
        msg[1] = 61;
        System.arraycopy(this.text.getBytes(StandardCharsets.UTF_8), 0, msg, 2, length);
        this.messageBytes = msg;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getMessageBytes() {
        return (byte[])this.messageBytes.clone();
    }

    byte[] getRawMessageBytes() {
        return this.messageBytes;
    }

    public static ScramServerErrorCode fromErrorString(String value) {
        try {
            return ScramServerErrorCode.valueOf(value.replace('-', '_').toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException ignored) {
            return OTHER_ERROR;
        }
    }

    public static boolean isFull(EnumSet<ScramServerErrorCode> set) {
        return set != null && set.size() == fullSize;
    }

    public boolean in(ScramServerErrorCode v1) {
        return this == v1;
    }

    public boolean in(ScramServerErrorCode v1, ScramServerErrorCode v2) {
        return this == v1 || this == v2;
    }

    public boolean in(ScramServerErrorCode v1, ScramServerErrorCode v2, ScramServerErrorCode v3) {
        return this == v1 || this == v2 || this == v3;
    }

    public boolean in(ScramServerErrorCode ... values) {
        if (values != null) {
            for (ScramServerErrorCode value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = ScramServerErrorCode.values().length;
    }
}

