/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500.cert;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.wildfly.common.Assert;
import org.wildfly.common.bytes.ByteStringBuilder;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.asn1.util.ASN1;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.x500.cert.CertUtil;
import org.wildfly.security.x500.cert.SubjectKeyIdentifierExtension;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public final class PKCS10CertificateSigningRequest {
    private final PublicKey publicKey;
    private final X500Principal subjectDn;
    private final List<X509CertificateExtension> extensions;
    private final byte[] encoded;

    private PKCS10CertificateSigningRequest(Builder builder, byte[] encoded) {
        this.publicKey = builder.publicKey;
        this.subjectDn = builder.subjectDn;
        this.extensions = new ArrayList(builder.extensionsByOid.values());
        this.encoded = encoded;
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public byte[] getPem() {
        ByteStringBuilder pem = new ByteStringBuilder();
        Pem.generatePemPKCS10CertificateSigningRequest(pem, this);
        return pem.toArray();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public X500Principal getSubjectDn() {
        return this.subjectDn;
    }

    public List<X509CertificateExtension> getExtensions() {
        return this.extensions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final int VERSION = 0;
        private Certificate certificate;
        private PublicKey publicKey;
        private PrivateKey signingKey;
        private String signatureAlgorithmName;
        private String signatureAlgorithmOid;
        private X500Principal subjectDn;
        private final Map<String, X509CertificateExtension> extensionsByOid = new LinkedHashMap<String, X509CertificateExtension>();

        Builder() {
        }

        public Builder setCertificate(Certificate certificate) {
            Assert.checkNotNullParam((String)"certificate", (Object)certificate);
            this.certificate = certificate;
            this.publicKey = certificate.getPublicKey();
            return this;
        }

        public Builder setSigningKey(PrivateKey signingKey) {
            Assert.checkNotNullParam((String)"signingKey", (Object)signingKey);
            this.signingKey = signingKey;
            return this;
        }

        public Builder setSubjectDn(X500Principal subjectDn) {
            Assert.checkNotNullParam((String)"subjectDn", (Object)subjectDn);
            this.subjectDn = subjectDn;
            return this;
        }

        public Builder setSignatureAlgorithmName(String signatureAlgorithmName) {
            Assert.checkNotNullParam((String)"signatureAlgorithmName", (Object)signatureAlgorithmName);
            this.signatureAlgorithmName = signatureAlgorithmName;
            return this;
        }

        public Builder addExtension(X509CertificateExtension extension) throws IllegalArgumentException {
            Assert.checkNotNullParam((String)"extension", (Object)extension);
            String oid = extension.getId();
            Assert.checkNotNullParam((String)"extension.getOid()", (Object)oid);
            if (this.extensionsByOid.putIfAbsent(oid, extension) != null) {
                throw ElytronMessages.log.extensionAlreadyExists(oid);
            }
            return this;
        }

        public Builder addExtension(boolean critical, String extensionName, String extensionValue) throws IllegalArgumentException {
            Assert.checkNotNullParam((String)"name", (Object)extensionName);
            Assert.checkNotNullParam((String)"value", (Object)extensionValue);
            return this.addExtension(CertUtil.getX509CertificateExtension(critical, extensionName, extensionValue));
        }

        public PKCS10CertificateSigningRequest build() throws IllegalArgumentException {
            if (this.certificate == null) {
                throw ElytronMessages.log.noCertificateGiven();
            }
            if (this.signingKey == null) {
                throw ElytronMessages.log.noSigningKeyGiven();
            }
            if (this.signatureAlgorithmName == null) {
                this.signatureAlgorithmName = CertUtil.getDefaultCompatibleSignatureAlgorithmName(this.signingKey);
                if (this.signatureAlgorithmName == null) {
                    throw ElytronMessages.log.noSignatureAlgorithmNameGiven();
                }
            }
            this.signatureAlgorithmOid = ASN1.oidFromSignatureAlgorithm(this.signatureAlgorithmName);
            if (this.signatureAlgorithmOid == null) {
                throw ElytronMessages.log.asnUnrecognisedAlgorithm(this.signatureAlgorithmName);
            }
            String signingKeyAlgorithm = this.signingKey.getAlgorithm();
            if (!this.signatureAlgorithmName.endsWith("with" + signingKeyAlgorithm) || this.signatureAlgorithmName.contains("with" + signingKeyAlgorithm + "and")) {
                throw ElytronMessages.log.signingKeyNotCompatWithSig(signingKeyAlgorithm, this.signatureAlgorithmName);
            }
            if (this.subjectDn == null) {
                this.subjectDn = ((X509Certificate)this.certificate).getSubjectX500Principal();
            }
            SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(CertUtil.getKeyIdentifier(this.publicKey));
            this.addExtension(subjectKeyIdentifierExtension);
            DEREncoder encoder = new DEREncoder();
            this.encodeCertificationRequest(encoder);
            return new PKCS10CertificateSigningRequest(this, encoder.getEncoded());
        }

        private void encodeCertificationRequest(DEREncoder encoder) {
            byte[] signatureBytes;
            DEREncoder tbsEncoder = new DEREncoder();
            this.encodeCertificationRequestInfo(tbsEncoder);
            try {
                Signature signature = Signature.getInstance(this.signatureAlgorithmName);
                signature.initSign(this.signingKey);
                signature.update(tbsEncoder.getEncoded());
                signatureBytes = signature.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                throw ElytronMessages.log.certRequestInfoSigningFailed(e);
            }
            encoder.startSequence();
            encoder.writeEncoded(tbsEncoder.getEncoded());
            this.encodeAlgorithmIdentifier(encoder);
            encoder.encodeBitString(signatureBytes);
            encoder.endSequence();
        }

        private void encodeCertificationRequestInfo(DEREncoder encoder) {
            encoder.startSequence();
            encoder.encodeInteger(0);
            encoder.writeEncoded(this.subjectDn.getEncoded());
            encoder.writeEncoded(this.publicKey.getEncoded());
            encoder.encodeImplicit(0);
            this.encodeAttributes(encoder);
            encoder.endSequence();
        }

        private void encodeAlgorithmIdentifier(DEREncoder encoder) {
            encoder.startSequence();
            encoder.encodeObjectIdentifier(this.signatureAlgorithmOid);
            if (this.signingKey.getAlgorithm().equals("RSA")) {
                encoder.encodeNull();
            }
            encoder.endSequence();
        }

        private void encodeAttributes(DEREncoder encoder) {
            encoder.startSetOf();
            encoder.startSequence();
            encoder.encodeObjectIdentifier("1.2.840.113549.1.9.14");
            encoder.startSetOf();
            this.encodeExtensionRequest(encoder);
            encoder.endSetOf();
            encoder.endSequence();
            encoder.endSetOf();
        }

        private void encodeExtensionRequest(DEREncoder encoder) {
            encoder.startSequence();
            for (X509CertificateExtension extension : this.extensionsByOid.values()) {
                Builder.encodeExtension(encoder, extension);
            }
            encoder.endSequence();
        }

        private static void encodeExtension(DEREncoder encoder, X509CertificateExtension extension) {
            encoder.startSequence();
            encoder.encodeObjectIdentifier(extension.getId());
            if (extension.isCritical()) {
                encoder.encodeBoolean(true);
            }
            DEREncoder extensionEncoder = new DEREncoder();
            extension.encodeTo(extensionEncoder);
            encoder.encodeOctetString(extensionEncoder.getEncoded());
            encoder.endSequence();
        }
    }
}

